; -------------------------------------------------------------------------------------------------------------- ;
; Beach Head - Chapter Data: Open Sea Plane Shootouts
; -------------------------------------------------------------------------------------------------------------- ;
                        incdir  ..\inc              ; C64 System Includes
;
C64CIA2                 include cia2.asm            ; Complex Interface Adapter (CIA) #2 Registers  $DD00-$DD0F
C64VicII                include vic.asm             ; Video Interface Chip (VIC-II) Registers       $D000-$D02E
C64Colors               include color.asm           ; Colour RAM Address / Colours
;
Game                    include inc\BH_Game.asm     ; Game Variables
; -------------------------------------------------------------------------------------------------------------- ;
                        * = BH_MemScreenSetA
; -------------------------------------------------------------------------------------------------------------- ;
Screen_Graphics         set  * ; 
;                            $00  $01  $02  $03  $04  $05  $06  $07  $08  $09  $0a  $0b  $0c  $0d  $0e  $0f  $10  $11  $12  $13  $14  $15  $16  $17  $18  $19  $1a  $1b  $1c  $1d  $1e  $1f  $20  $21  $22  $23  $24  $25  $26  $27 ; 
Screen_SeaPlane_Row01   dc.b $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73 ; 
Screen_SeaPlane_Row02   dc.b $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73 ; 
Screen_SeaPlane_Row03   dc.b $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73 ; 
Screen_SeaPlane_Row04   dc.b $73, $73, $73, $73, $73, $73, $2a, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73 ; 
Screen_SeaPlane_Row05   dc.b $73, $73, $73, $73, $73, $28, $29, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $3f, $40, $41, $42, $43, $73, $73, $73, $73, $73 ; 
Screen_SeaPlane_Row06   dc.b $73, $73, $73, $73, $73, $2c, $2d, $2e, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $45, $46, $47, $48, $49, $4a, $4b, $73, $73, $73, $73, $73 ; 
Screen_SeaPlane_Row07   dc.b $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $4d, $4e, $4f, $4f, $50, $51, $52, $44, $73, $73, $73, $73, $73 ; 
Screen_SeaPlane_Row08   dc.b $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $53, $54, $55, $56, $57, $58, $59, $5a, $73, $73, $73, $73, $73 ; 
Screen_SeaPlane_Row09   dc.b $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $60, $61, $62, $63, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73 ; 
Screen_SeaPlane_Row0a   dc.b $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73 ; 
Screen_SeaPlane_Row0b   dc.b $73, $73, $68, $69, $6a, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $64, $65, $66, $73, $73 ; 
Screen_SeaPlane_Row0c   dc.b $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $6c, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73 ; 
Screen_SeaPlane_Row0d   dc.b $73, $73, $73, $73, $73, $73, $73, $73, $6d, $73, $73, $6f, $6b, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $73, $6c, $73 ; 
Screen_SeaPlane_Row0e   dc.b $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30 ; 
Screen_SeaPlane_Row0f   dc.b $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30 ; 
Screen_SeaPlane_Row10   dc.b $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30 ; 
Screen_SeaPlane_Row11   dc.b $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30 ; 
Screen_SeaPlane_Row12   dc.b $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30 ; 
Screen_SeaPlane_Row13   dc.b $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30, $30 ; 
                        
Screen_Status_Text      set *                          ; 
Screen_SeaPlane_Row14   dc.b $75, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $76 ; 
                        include inc\BH_StatusTexts.asm ; default texts
Screen_Status_Text_End  set *          ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        * = [Status_Text_Row01 + BH_Scrn_Stat_LeTxt - $03] ; 
Screen_Status_Header    set *
                        dc.b "K" - $40 ; .hbu011.
                        dc.b "A" - $40 ; 
                        dc.b "M" - $40 ; 
                        dc.b "I" - $40 ; 
                        dc.b "K" - $40 ; 
                        dc.b "A" - $40 ; 
                        dc.b "Z" - $40 ; 
                        dc.b "E" - $40 ; 
                        dc.b " "       ; 
                        dc.b "S" - $40 ; 
                        dc.b "K" - $40 ; 
                        dc.b "I" - $40 ; 
                        dc.b "E" - $40 ; 
                        dc.b "S" - $40 ; 
                        * = Status_Text_Row01 + BH_Scrn_Stat_RiTxt ; 
Screen_SeaPlane_Hits    = *
                        dc.b "H" - $40 ; .hbu011.
                        dc.b "I" - $40 ; 
                        dc.b "T" - $40 ; 
                        dc.b "S" - $40 ; 
                        * = Status_Text_Row02 + BH_Scrn_Stat_RiTxt ; 
Screen_SeaPlane_Ammo    = *
                        dc.b "A" - $40 ; .hbu011.
                        dc.b "M" - $40 ; 
                        dc.b "M" - $40 ; 
                        dc.b "O" - $40 ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        * = Screen_Graphics + BH_Vessel1ScrnPos                  ; vessel_1
Screen_SeaPlane_V_1a    = *                                                      ; 
                        dc.b $2f                                                 ; 
                        * = Screen_Graphics + BH_Vessel1ScrnPos + BH_Scrn_RowLen ; 
Screen_SeaPlane_V_1b    = *                                                      ; 
                        dc.b $31, $4c                                            ; 
                        
                        * = Screen_Graphics + BH_Vessel2ScrnPos                  ; vessel_2
Screen_SeaPlane_V_2a    = *                                                      ; 
                        dc.b $6f, $6b                                            ; 
                        * = Screen_Graphics + BH_Vessel2ScrnPos + BH_Scrn_RowLen - $01 ; 
Screen_SeaPlane_V_2b    = *                                                      ; 
                        dc.b $72, $71, $70                                       ; 
                        
                        * = Screen_Graphics + BH_Vessel3ScrnPos                  ; vessel_3
Screen_SeaPlane_V_3     = *                                                      ; 
                        dc.b $2b                                                 ; 
                        
                        * = Screen_Graphics + BH_Vessel4ScrnPos                  ; vessel_4
Screen_SeaPlaneV_4      = *                                                      ; 
                        dc.b $5b, $5c, $5d, $5e, $5f                             ; 
                        
                        * = Screen_Graphics + BH_CarrierScrnPos                  ; carrier
Screen_SeaPlane_C_1a    = *                                                      ; 
                        dc.b $32                                                 ; 
                        * = Screen_Graphics + BH_CarrierScrnPos + [BH_Scrn_RowLen * $01] - $04 ; 
Screen_SeaPlane_C_1b    = *                                                      ; 
                        dc.b $3b, $33, $34, $35, $36, $37, $38, $39, $3a         ; 
                        * = Screen_Graphics + BH_CarrierScrnPos + [BH_Scrn_RowLen * $02] - $04 ; 
Screen_SeaPlane_C_1c    = *                                                      ; 
                        dc.b $3c, $3d, $3d, $3d, $3d, $3d, $3d, $3d, $3e, $6e    ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        * = BH_MemScreenSetB
; -------------------------------------------------------------------------------------------------------------- ;
Chapter_Screen_Values   set  *      ; individual settings
Misc_SeaPlane_Raster    dc.b $c6    ; TabControlRaster
Misc_SeaPlane_St_Len    dc.b [Colors_Status_End - Colors_Status] ; copy status lenght
Misc_SeaPlane_St_Off_Lo dc.b <[Colors_Status - Colors_Screen]    ; copy status offset
Misc_SeaPlane_St_Off_Hi dc.b >[Colors_Status - Colors_Screen]    ; 
                        
Colors_Screen_Base      set  * ; 
                        dc.b CYAN   ; TabBackGroundColor
                        dc.b BLUE   ; BGCOL1
                        dc.b YELLOW ; BGCOL2
Colors_Screen           set  * ; 
;                            $00  $01  $02  $03  $04  $05  $06  $07  $08  $09  $0a  $0b  $0c  $0d  $0e  $0f  $10  $11  $12  $13  $14  $15  $16  $17  $18  $19  $1a  $1b  $1c  $1d  $1e  $1f  $20  $21  $22  $23  $24  $25  $26  $27 ; 
Colors_SeaPlane_Row01   dc.b $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ; 
Colors_SeaPlane_Row02   dc.b $03, $03, $03, $03, $03, $03, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ; 
Colors_SeaPlane_Row03   dc.b $03, $03, $03, $03, $03, $03, $03, $03, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ; 
Colors_SeaPlane_Row04   dc.b $03, $03, $03, $03, $03, $00, $01, $00, $03, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ; 
Colors_SeaPlane_Row05   dc.b $03, $03, $03, $03, $03, $01, $01, $00, $03, $03, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $01, $00, $00, $01, $01, $01, $01, $01, $00, $00, $00, $00, $00 ; 
Colors_SeaPlane_Row06   dc.b $03, $03, $03, $03, $03, $01, $01, $01, $03, $00, $00, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $01, $01, $01, $01, $01, $01, $01, $03, $03, $03, $03, $03 ; 
Colors_SeaPlane_Row07   dc.b $03, $03, $03, $03, $03, $03, $00, $00, $00, $00, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $00, $00, $00, $00, $00, $00, $01, $01, $01, $01, $01, $01, $01, $01, $03, $03, $03, $03, $03 ; 
Colors_SeaPlane_Row08   dc.b $03, $03, $03, $03, $03, $03, $03, $00, $00, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $00, $00, $00, $00, $00, $00, $01, $01, $01, $01, $01, $01, $01, $01, $03, $03, $03, $03, $03 ; 
Colors_SeaPlane_Row09   dc.b $03, $03, $03, $03, $03, $03, $00, $00, $03, $03, $03, $03, $03, $01, $01, $01, $01, $03, $03, $03, $03, $00, $00, $00, $00, $00, $00, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03 ; 
Colors_SeaPlane_Row0a   dc.b $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $00, $00, $00, $00, $00, $00, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03 ; 
Colors_SeaPlane_Row0b   dc.b $03, $03, $01, $01, $01, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $00, $00, $00, $00, $00, $00, $03, $03, $03, $03, $03, $03, $03, $03, $01, $01, $01, $03, $03 ; 
Colors_SeaPlane_Row0c   dc.b $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $01, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03 ; 
Colors_SeaPlane_Row0d   dc.b $03, $03, $03, $03, $03, $03, $03, $03, $01, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $00, $03, $01, $03 ; 
Colors_SeaPlane_Row0e   dc.b $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e ; 
Colors_SeaPlane_Row0f   dc.b $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e ; 
Colors_SeaPlane_Row10   dc.b $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e ; 
Colors_SeaPlane_Row11   dc.b $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e ; 
Colors_SeaPlane_Row12   dc.b $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e ; 
Colors_SeaPlane_Row13   dc.b $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e, $0e ; 
                        
Colors_Status           set  * ; 
Colors_SeaPlane_Row14   dc.b $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c, $1c ; 
                        include inc\BH_StatusColor.asm ; default colors
Colors_Status_End       set  * ; 
                        
;Colors_Status_Free     dc.b $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ; unused - 3 for base
; -------------------------------------------------------------------------------------------------------------- ;
                        * = [Status_Color_Row01 + BH_Scrn_Stat_RiTxt]       ; 
Colors_SeaPlane_Hits    repeat 5      ; .hbu011.
                        dc.b WHITE    ; 
                        repend        ; 
                        
                        * = [Status_Color_Row01 + BH_Scrn_Stat_RiVal]       ; 
Colors_SeaPlane_HitsNo  repeat 2      ; .hbu011.
                        dc.b LT_RED   ; 
                        repend        ; 
                        
                        * = [Status_Color_Row02 + BH_Scrn_Stat_RiTxt]       ; 
Colors_SeaPlane_Ammo    repeat 5      ; .hbu011.
                        dc.b WHITE    ; 
                        repend        ; 
                        
                        * = [Status_Color_Row02 + BH_Scrn_Stat_RiVal]       ; 
Colors_SeaPlane_AmmoNo  repeat 10     ; .hbu011.
                        dc.b GREEN    ; 
                        repend        ; 
                        
                        * = [Status_Color_Row03 + BH_Scrn_Stat_LeTxt]       ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        * = Colors_Screen + BH_Vessel1ScrnPos                                ; vessel_1
Colors_SeaPlane_V_1a    = *                                                                  ; 
                        dc.b $00, $00                                                        ; 
                        * = Colors_Screen + BH_Vessel1ScrnPos + BH_Scrn_RowLen               ; 
Colors_SeaPlane_V_1b    = *                                                                  ; 
                        dc.b $00, $00                                                        ; 
                        
                        * = Colors_Screen + BH_Vessel2ScrnPos                                ; vessel_2
Colors_SeaPlane_V_2a    = *                                                                  ; 
                        dc.b $00, $00                                                        ; 
                        * = Colors_Screen + BH_Vessel2ScrnPos + BH_Scrn_RowLen - $01         ; 
Colors_SeaPlane_V_2b    = *                                                                  ; 
                        dc.b $09, $08, $08                                                   ; 
                        
                        * = Colors_Screen + BH_Vessel3ScrnPos                                ; vessel_3
Colors_SeaPlane_V_3     = *                                                                  ; 
                        dc.b $00                                                             ; 
                        
                        * = Colors_Screen + BH_Vessel4ScrnPos                                ; vessel_4
Colors_SeaPlane_V_4     = *                                                                  ; 
                        dc.b $08, $08, $08, $08, $09                                         ; 
                        
                        * = Colors_Screen + BH_CarrierScrnPos                                ; carrier
Colors_SeaPlane_C_1a    = *                                                                  ; 
                        dc.b $00                                                             ; 
                        * = Colors_Screen + BH_CarrierScrnPos + [BH_Scrn_RowLen * $01] - $04 ; 
Colors_SeaPlane_C_1b    = *                                                                  ; 
                        dc.b $00, $00, $00, $00, $00, $00, $00, $00, $00                     ; 
                        * = Colors_Screen + BH_CarrierScrnPos + [BH_Scrn_RowLen * $02] - $04 ; 
Colors_SeaPlane_C_1c    = *                                                                  ; 
                        dc.b $08, $08, $08, $08, $08, $08, $08, $08, $08, $09                ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        * = BH_MemCharSet
; -------------------------------------------------------------------------------------------------------------- ;
ChrSet_SeaPlane         equ  *   ; 
                        
MapChar00               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar01               dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar02               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        
MapChar03               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $c0 ; ##......
                        
MapChar04               dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar05               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $bf ; #.######
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar06               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $bc ; #.####..
                        dc.b $af ; #.#.####
                        
MapChar07               dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar08               dc.b $c0 ; ##......
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar09               dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $f0 ; ####....
                        dc.b $bc ; #.####..
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        
MapChar0a               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        
MapChar0b               dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar0c               dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar0d               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $af ; #.#.####
                        
MapChar0e               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        
MapChar0f               dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar10               dc.b $aa ; #.#.#.#.
                        dc.b $be ; #.#####.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $00 ; ........
                        
MapChar11               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $c0 ; ##......
                        dc.b $00 ; ........
                        
MapChar12               dc.b $aa ; #.#.#.#.
                        dc.b $be ; #.#####.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $f8 ; #####...
                        dc.b $c0 ; ##......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar13               dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $ef ; ###.####
                        dc.b $ff ; ########
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar14               dc.b $aa ; #.#.#.#.
                        dc.b $be ; #.#####.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $f0 ; ####....
                        dc.b $c0 ; ##......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar15               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        
MapChar16               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $0f ; ....####
                        
MapChar17               dc.b $af ; #.#.####
                        dc.b $af ; #.#.####
                        dc.b $bf ; #.######
                        dc.b $bf ; #.######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar18               dc.b $f0 ; ####....
                        dc.b $c0 ; ##......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        
MapChar19               dc.b $ff ; ########
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        
MapChar1a               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar1b               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fa ; #####.#.
                        dc.b $fa ; #####.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $fa ; #####.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar1c               dc.b $00 ; ........
                        dc.b $fc ; ######..
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar1d               dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar1e               dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar1f               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f4 ; ####.#..
                        dc.b $f5 ; ####.#.#
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        
MapChar20               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $07 ; .....###
                        dc.b $57 ; .#.#.###
                        dc.b $ff ; ########
                        dc.b $aa ; #.#.#.#.
                        
MapChar21               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        
MapChar22               dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar23               dc.b $fa ; #####.#.
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar24               dc.b $aa ; #.#.#.#.
                        dc.b $be ; #.#####.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $cf ; ##..####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        
MapChar25               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $00 ; ........
                        
MapChar26               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $fa ; #####.#.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        
MapChar27               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $fa ; #####.#.
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        
SeaPlaneChar28          dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
SeaPlaneChar29          dc.b $fe ; #######.
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $e3 ; ###...##
                        dc.b $c7 ; ##...###
                        dc.b $ff ; ########
                        
SeaPlaneChar2a          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $38 ; ..###...
                        dc.b $3c ; ..####..
                        dc.b $1e ; ...####.
                        dc.b $7e ; .######.
                        dc.b $ff ; ########
                        
SeaPlaneChar2b          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $10 ; ...#....
                        dc.b $38 ; ..###...
                        dc.b $7c ; .#####..
                        dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        
SeaPlaneChar2c          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $c7 ; ##...###
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        
SeaPlaneChar2d          dc.b $87 ; #....###
                        dc.b $fe ; #######.
                        dc.b $1c ; ...###..
                        dc.b $f0 ; ####....
                        dc.b $c0 ; ##......
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        
SeaPlaneChar2e          dc.b $f8 ; #####...
                        dc.b $c0 ; ##......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        
SeaPlaneChar2f          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $01 ; .......#
                        
SeaPlaneChar30          dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
SeaPlaneChar31          dc.b $03 ; ......##
                        dc.b $01 ; .......#
                        dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        
SeaPlaneChar32          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $20 ; ..#.....
                        dc.b $70 ; .###....
                        dc.b $22 ; ..#...#.
                        
SeaPlaneChar33          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $44 ; .#...#..
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
SeaPlaneChar34          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $44 ; .#...#..
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
SeaPlaneChar35          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $40 ; .#......
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
SeaPlaneChar36          dc.b $73 ; .###..##
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
SeaPlaneChar37          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
SeaPlaneChar38          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $08 ; ....#...
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
SeaPlaneChar39          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $88 ; #...#...
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
SeaPlaneChar3a          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $80 ; #.......
                        dc.b $ff ; ########
                        dc.b $f0 ; ####....
                        
SeaPlaneChar3b          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $04 ; .....#..
                        dc.b $ff ; ########
                        dc.b $0f ; ....####
                        
SeaPlaneChar3c          dc.b $57 ; .#.#.###
                        dc.b $57 ; .#.#.###
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
SeaPlaneChar3d          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
SeaPlaneChar3e          dc.b $f5 ; ####.#.#
                        dc.b $e9 ; ###.#..#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
SeaPlaneChar3f          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $18 ; ...##...
                        dc.b $3c ; ..####..
                        dc.b $ff ; ########
                        
SeaPlaneChar40          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $3e ; ..#####.
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        
SeaPlaneChar41          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $3c ; ..####..
                        dc.b $7e ; .######.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
SeaPlaneChar42          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $f8 ; #####...
                        
SeaPlaneChar43          dc.b $0e ; ....###.
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $7e ; .######.
                        dc.b $7c ; .#####..
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
SeaPlaneChar44          dc.b $ff ; ########
                        dc.b $f0 ; ####....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
SeaPlaneChar45          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $3c ; ..####..
                        dc.b $ff ; ########
                        
SeaPlaneChar46          dc.b $01 ; .......#
                        dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        
SeaPlaneChar47          dc.b $e7 ; ###..###
                        dc.b $c7 ; ##...###
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $1f ; ...#####
                        dc.b $f8 ; #####...
                        dc.b $fe ; #######.
                        dc.b $cf ; ##..####
                        
SeaPlaneChar48          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $c3 ; ##....##
                        dc.b $ff ; ########
                        dc.b $cc ; ##..##..
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
SeaPlaneChar49          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
SeaPlaneChar4a          dc.b $fe ; #######.
                        dc.b $f8 ; #####...
                        dc.b $e3 ; ###...##
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
SeaPlaneChar4b          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        
SeaPlaneChar4c          dc.b $80 ; #.......
                        dc.b $00 ; ........
                        dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        
SeaPlaneChar4d          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        
SeaPlaneChar4e          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $f1 ; ####...#
                        dc.b $cf ; ##..####
                        dc.b $ff ; ########
                        dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $ff ; ########
                        
SeaPlaneChar4f          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
SeaPlaneChar50          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $e0 ; ###.....
                        
SeaPlaneChar51          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $f8 ; #####...
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        
SeaPlaneChar52          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
SeaPlaneChar53          dc.b $33 ; ..##..##
                        dc.b $ff ; ########
                        dc.b $30 ; ..##....
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
SeaPlaneChar54          dc.b $c3 ; ##....##
                        dc.b $ff ; ########
                        dc.b $f3 ; ####..##
                        dc.b $df ; ##.#####
                        dc.b $ef ; ###.####
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
SeaPlaneChar55          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
SeaPlaneChar56          dc.b $f8 ; #####...
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $00 ; ........
                        
SeaPlaneChar57          dc.b $c7 ; ##...###
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $00 ; ........
                        
SeaPlaneChar58          dc.b $f8 ; #####...
                        dc.b $f3 ; ####..##
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
SeaPlaneChar59          dc.b $80 ; #.......
                        dc.b $f8 ; #####...
                        dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        dc.b $f8 ; #####...
                        dc.b $fe ; #######.
                        dc.b $c3 ; ##....##
                        dc.b $f1 ; ####...#
                        
SeaPlaneChar5a          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $e0 ; ###.....
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        
SeaPlaneChar5b          dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $ff ; ########
                        dc.b $4f ; .#..####
                        dc.b $53 ; .#.#..##
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
SeaPlaneChar5c          dc.b $4d ; .#..##.#
                        dc.b $4d ; .#..##.#
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
SeaPlaneChar5d          dc.b $55 ; .#.#.#.#
                        dc.b $d5 ; ##.#.#.#
                        dc.b $d5 ; ##.#.#.#
                        dc.b $c0 ; ##......
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
SeaPlaneChar5e          dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $01 ; .......#
                        dc.b $fd ; ######.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
SeaPlaneChar5f          dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $f7 ; ####.###
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
SeaPlaneChar60          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $0c ; ....##..
                        dc.b $3f ; ..######
                        dc.b $01 ; .......#
                        dc.b $07 ; .....###
                        
SeaPlaneChar61          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $3e ; ..#####.
                        dc.b $f1 ; ####...#
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $e0 ; ###.....
                        
SeaPlaneChar62          dc.b $3c ; ..####..
                        dc.b $7e ; .######.
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $07 ; .....###
                        dc.b $ff ; ########
                        dc.b $f8 ; #####...
                        dc.b $1f ; ...#####
                        
SeaPlaneChar63          dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $f8 ; #####...
                        
SeaPlaneChar64          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $23 ; ..#...##
                        dc.b $f8 ; #####...
                        dc.b $7f ; .#######
                        
SeaPlaneChar65          dc.b $0e ; ....###.
                        dc.b $1f ; ...#####
                        dc.b $03 ; ......##
                        dc.b $f8 ; #####...
                        dc.b $f7 ; ####.###
                        dc.b $fe ; #######.
                        dc.b $f0 ; ####....
                        dc.b $00 ; ........
                        
SeaPlaneChar66          dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $d8 ; ##.##...
                        dc.b $b4 ; #.##.#..
                        dc.b $fc ; ######..
                        dc.b $d6 ; ##.#.##.
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        
SeaPlaneChar67          dc.b $f0 ; ####....
                        dc.b $78 ; .####...
                        dc.b $3e ; ..#####.
                        dc.b $1f ; ...#####
                        dc.b $0e ; ....###.
                        dc.b $04 ; .....#..
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
SeaPlaneChar68          dc.b $00 ; ........
                        dc.b $ff ; ########
                        dc.b $1f ; ...#####
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
SeaPlaneChar69          dc.b $00 ; ........
                        dc.b $e0 ; ###.....
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
SeaPlaneChar6a          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $e0 ; ###.....
                        dc.b $fc ; ######..
                        dc.b $3f ; ..######
                        dc.b $00 ; ........
                        
SeaPlaneChar6b          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $40 ; .#......
                        dc.b $60 ; .##.....
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        
SeaPlaneChar6c          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $38 ; ..###...
                        dc.b $fe ; #######.
                        dc.b $00 ; ........
                        
SeaPlaneChar6d          dc.b $00 ; ........
                        dc.b $7c ; .#####..
                        dc.b $1e ; ...####.
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
SeaPlaneChar6e          dc.b $55 ; .#.#.#.#
                        dc.b $f7 ; ####.###
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
SeaPlaneChar6f          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $01 ; .......#
                        dc.b $07 ; .....###
                        
SeaPlaneChar70          dc.b $fd ; ######.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
SeaPlaneChar71          dc.b $ff ; ########
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
SeaPlaneChar72          dc.b $df ; ##.#####
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
SeaPlaneChar73          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
; -------------------------------------------------------------------------------------------------------------- ;
                        * = BH_MemSprites
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_00    dc.b %00000000, %00000000, %00000000 ; 5000 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5003 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5006 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5009 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 500c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 500f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5012 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5015 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5018 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 501b ; ........................
                        dc.b %00000000, %00011000, %00000000 ; 501e ; ...........##...........
                        dc.b %00000000, %00000000, %00000000 ; 5021 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5024 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5027 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 502a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 502d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5030 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5033 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5036 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5039 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 503c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_01    dc.b %00000000, %00000000, %00000000 ; 5040 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5043 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5046 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5049 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 504c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 504f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5052 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5055 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5058 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 505b ; ........................
                        dc.b %00000000, %00111100, %00000000 ; 505e ; ..........####..........
                        dc.b %00000000, %00000000, %00000000 ; 5061 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5064 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5067 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 506a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 506d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5070 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5073 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5076 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5079 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 507c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_02    dc.b %00000000, %00000000, %00000000 ; 5080 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5083 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5086 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5089 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 508c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 508f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5092 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5095 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5098 ; ........................
                        dc.b %00000000, %00011000, %00000000 ; 509b ; ...........##...........
                        dc.b %00000000, %01111110, %00000000 ; 509e ; .........######.........
                        dc.b %00000000, %00000000, %00000000 ; 50a1 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50a4 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50a7 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50aa ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50ad ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50b0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50b3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50b6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50b9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50bc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_03    dc.b %00000000, %00000000, %00000000 ; 50c0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50c3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50c6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50c9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50cc ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50cf ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50d2 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50d5 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50d8 ; ........................
                        dc.b %00000000, %00011000, %00000000 ; 50db ; ...........##...........
                        dc.b %00000001, %11111111, %10000000 ; 50de ; .......##########.......
                        dc.b %00000000, %00000000, %00000000 ; 50e1 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50e4 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50e7 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50ea ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50ed ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50f0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50f3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50f6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50f9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50fc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_04    dc.b %00000000, %00000000, %00000000 ; 5100 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5103 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5106 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5109 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 510c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 510f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5112 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5115 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5118 ; ........................
                        dc.b %00000000, %00011000, %00000000 ; 511b ; ...........##...........
                        dc.b %00000111, %11111111, %11100000 ; 511e ; .....##############.....
                        dc.b %00000000, %00000000, %00000000 ; 5121 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5124 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5127 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 512a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 512d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5130 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5133 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5136 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5139 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 513c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_05    dc.b %00000000, %00000000, %00000000 ; 5140 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5143 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5146 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5149 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 514c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 514f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5152 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5155 ; ........................
                        dc.b %00000000, %00011000, %00000000 ; 5158 ; ...........##...........
                        dc.b %00000000, %00011000, %00000000 ; 515b ; ...........##...........
                        dc.b %00011111, %11100111, %11111000 ; 515e ; ...########..########...
                        dc.b %00000001, %10000001, %10000000 ; 5161 ; .......##......##.......
                        dc.b %00000000, %00000000, %00000000 ; 5164 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5167 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 516a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 516d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5170 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5173 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5176 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5179 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 517c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_06    dc.b %00000000, %00000000, %00000000 ; 5180 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5183 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5186 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5189 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 518c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 518f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5192 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5195 ; ........................
                        dc.b %00000000, %00011000, %00000000 ; 5198 ; ...........##...........
                        dc.b %00000000, %00011000, %00000000 ; 519b ; ...........##...........
                        dc.b %01111111, %11100111, %11111110 ; 519e ; .##########..##########.
                        dc.b %00000011, %00000000, %11000000 ; 51a1 ; ......##........##......
                        dc.b %00000000, %00000000, %00000000 ; 51a4 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51a7 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51aa ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51ad ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51b0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51b3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51b6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51b9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51bc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_07    dc.b %00000000, %00000000, %00000000 ; 51c0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51c3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51c6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51c9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51cc ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51cf ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51d2 ; ........................
                        dc.b %00000000, %00000000, %00000001 ; 51d5 ; .......................#
                        dc.b %00000000, %00000000, %00000001 ; 51d8 ; .......................#
                        dc.b %00000000, %00000000, %00000011 ; 51db ; ......................##
                        dc.b %00000000, %00011111, %11111100 ; 51de ; ...........###########..
                        dc.b %00000000, %00000000, %01100000 ; 51e1 ; .................##.....
                        dc.b %00000000, %00000000, %00000000 ; 51e4 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51e7 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51ea ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51ed ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51f0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51f3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51f6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51f9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51fc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_08    dc.b %00000000, %00000000, %00000000 ; 5200 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5203 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5206 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5209 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 520c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 520f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5212 ; ........................
                        dc.b %10000000, %00000000, %00000000 ; 5215 ; #.......................
                        dc.b %10000000, %00000000, %00000000 ; 5218 ; #.......................
                        dc.b %11000000, %00000000, %00000000 ; 521b ; ##......................
                        dc.b %00111111, %11111000, %00000000 ; 521e ; ..###########...........
                        dc.b %00000111, %00000000, %00000000 ; 5221 ; .....###................
                        dc.b %00000000, %00000000, %00000000 ; 5224 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5227 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 522a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 522d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5230 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5233 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5236 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5239 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 523c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_09    dc.b %00000000, %00000000, %00000000 ; 5240 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5243 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5246 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5249 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 524c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 524f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5252 ; ........................
                        dc.b %00000000, %00000000, %00000001 ; 5255 ; .......................#
                        dc.b %00000000, %00000000, %00000001 ; 5258 ; .......................#
                        dc.b %00000000, %00000000, %00000111 ; 525b ; .....................###
                        dc.b %00000000, %01111111, %11111001 ; 525e ; .........############..#
                        dc.b %00000000, %00000000, %11000000 ; 5261 ; ................##......
                        dc.b %00000000, %00000000, %00000000 ; 5264 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5267 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 526a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 526d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5270 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5273 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5276 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5279 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 527c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_0a    dc.b %00000000, %00000000, %00000000 ; 5280 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5283 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5286 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5289 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 528c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 528f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5292 ; ........................
                        dc.b %10000000, %00000000, %00000000 ; 5295 ; #.......................
                        dc.b %10000000, %00000000, %00000000 ; 5298 ; #.......................
                        dc.b %11100000, %00000000, %00000000 ; 529b ; ###.....................
                        dc.b %10011111, %11111110, %00000000 ; 529e ; #..############.........
                        dc.b %00000011, %00000000, %00000000 ; 52a1 ; ......##................
                        dc.b %00000000, %00000000, %00000000 ; 52a4 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52a7 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52aa ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52ad ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52b0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52b3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52b6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52b9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52bc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_0b    dc.b %00000000, %00000000, %00000000 ; 52c0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52c3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52c6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52c9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52cc ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52cf ; ........................
                        dc.b %00000000, %00000000, %00000001 ; 52d2 ; .......................#
                        dc.b %00000000, %00000000, %00000101 ; 52d5 ; .....................#.#
                        dc.b %00000000, %00000000, %00000001 ; 52d8 ; .......................#
                        dc.b %00000000, %00000000, %00000111 ; 52db ; .....................###
                        dc.b %00000001, %11111111, %11111001 ; 52de ; .......##############..#
                        dc.b %00000000, %00000001, %10000000 ; 52e1 ; ...............##.......
                        dc.b %00000000, %00000000, %00000000 ; 52e4 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52e7 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52ea ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52ed ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52f0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52f3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52f6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52f9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52fc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_0c    dc.b %00000000, %00000000, %00000000 ; 5300 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5303 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5306 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5309 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 530c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 530f ; ........................
                        dc.b %10000000, %00000000, %00000000 ; 5312 ; #.......................
                        dc.b %10100000, %00000000, %00000000 ; 5315 ; #.#.....................
                        dc.b %10000000, %00000000, %00000000 ; 5318 ; #.......................
                        dc.b %11100000, %00000000, %00000000 ; 531b ; ###.....................
                        dc.b %10011111, %11111111, %10000000 ; 531e ; #..##############.......
                        dc.b %00000001, %10000000, %00000000 ; 5321 ; .......##...............
                        dc.b %00000000, %00000000, %00000000 ; 5324 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5327 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 532a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 532d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5330 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5333 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5336 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5339 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 533c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_0d    dc.b %00000000, %00000000, %00000000 ; 5340 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5343 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5346 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5349 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 534c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 534f ; ........................
                        dc.b %00000000, %00000000, %00000001 ; 5352 ; .......................#
                        dc.b %00000000, %00000000, %00000101 ; 5355 ; .....................#.#
                        dc.b %00000000, %00000000, %00000001 ; 5358 ; .......................#
                        dc.b %00000000, %00000000, %00001111 ; 535b ; ....................####
                        dc.b %00000111, %11111111, %11110001 ; 535e ; .....###############...#
                        dc.b %00000000, %00000011, %00000000 ; 5361 ; ..............##........
                        dc.b %00000000, %00000000, %00000000 ; 5364 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5367 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 536a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 536d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5370 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5373 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5376 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5379 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 537c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_0e    dc.b %00000000, %00000000, %00000000 ; 5380 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5383 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5386 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5389 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 538c ; ........................
                        dc.b %10000000, %00000000, %00000000 ; 538f ; #.......................
                        dc.b %10000000, %00000000, %00000000 ; 5392 ; #.......................
                        dc.b %10100000, %00000000, %00000000 ; 5395 ; #.#.....................
                        dc.b %10000000, %00000000, %00000000 ; 5398 ; #.......................
                        dc.b %11110000, %00000000, %00000000 ; 539b ; ####....................
                        dc.b %10001111, %11111111, %11100000 ; 539e ; #...###############.....
                        dc.b %00000000, %11000000, %00000000 ; 53a1 ; ........##..............
                        dc.b %00000000, %00000000, %00000000 ; 53a4 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 53a7 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 53aa ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 53ad ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 53b0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 53b3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 53b6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 53b9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 53bc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_0f    dc.b %00000000, %00000000, %00000000 ; 53c0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 53c3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 53c6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 53c9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 53cc ; ........................
                        dc.b %00000000, %00000000, %00000001 ; 53cf ; .......................#
                        dc.b %00000000, %00000000, %00001101 ; 53d2 ; ....................##.#
                        dc.b %00000000, %00000000, %00000001 ; 53d5 ; .......................#
                        dc.b %00000000, %00000000, %00000011 ; 53d8 ; ......................##
                        dc.b %00000000, %00000000, %00011111 ; 53db ; ...................#####
                        dc.b %00011111, %11111111, %11110001 ; 53de ; ...#################...#
                        dc.b %00000000, %00000110, %00000000 ; 53e1 ; .............##.........
                        dc.b %00000000, %00000000, %00000000 ; 53e4 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 53e7 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 53ea ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 53ed ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 53f0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 53f3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 53f6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 53f9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 53fc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_10    dc.b %00000000, %00000000, %00000000 ; 5400 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5403 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5406 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5409 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 540c ; ........................
                        dc.b %10000000, %00000000, %00000000 ; 540f ; #.......................
                        dc.b %10110000, %00000000, %00000000 ; 5412 ; #.##....................
                        dc.b %10000000, %00000000, %00000000 ; 5415 ; #.......................
                        dc.b %11000000, %00000000, %00000000 ; 5418 ; ##......................
                        dc.b %11111000, %00000000, %00000000 ; 541b ; #####...................
                        dc.b %10001111, %11111111, %11111000 ; 541e ; #...#################...
                        dc.b %00000000, %01100000, %00000000 ; 5421 ; .........##.............
                        dc.b %00000000, %00000000, %00000000 ; 5424 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5427 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 542a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 542d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5430 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5433 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5436 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5439 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 543c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_11    dc.b %00000000, %00000000, %00000000 ; 5440 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5443 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5446 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5449 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 544c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 544f ; ........................
                        dc.b %00000000, %00000000, %00000001 ; 5452 ; .......................#
                        dc.b %00000000, %00000000, %00001011 ; 5455 ; ....................#.##
                        dc.b %00000000, %00000000, %00000011 ; 5458 ; ......................##
                        dc.b %00000000, %00000000, %00011111 ; 545b ; ...................#####
                        dc.b %00011111, %11111111, %11111111 ; 545e ; ...#####################
                        dc.b %00000000, %11111111, %11110001 ; 5461 ; ........############...#
                        dc.b %00000000, %00000110, %00000000 ; 5464 ; .............##.........
                        dc.b %00000000, %00000000, %00000000 ; 5467 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 546a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 546d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5470 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5473 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5476 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5479 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 547c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_12    dc.b %00000000, %00000000, %00000000 ; 5480 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5483 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5486 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5489 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 548c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 548f ; ........................
                        dc.b %10000000, %00000000, %00000000 ; 5492 ; #.......................
                        dc.b %11010000, %00000000, %00000000 ; 5495 ; ##.#....................
                        dc.b %11000000, %00000000, %00000000 ; 5498 ; ##......................
                        dc.b %11111000, %00000000, %00000000 ; 549b ; #####...................
                        dc.b %11111111, %11111111, %11111000 ; 549e ; #####################...
                        dc.b %10001111, %11111111, %00000000 ; 54a1 ; #...############........
                        dc.b %00000000, %01100000, %00000000 ; 54a4 ; .........##.............
                        dc.b %00000000, %00000000, %00000000 ; 54a7 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 54aa ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 54ad ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 54b0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 54b3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 54b6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 54b9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 54bc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_13    dc.b %00000000, %00000000, %00000000 ; 54c0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 54c3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 54c6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 54c9 ; ........................
                        dc.b %00000000, %00000000, %00000001 ; 54cc ; .......................#
                        dc.b %00000000, %00000000, %00000001 ; 54cf ; .......................#
                        dc.b %00000000, %00000000, %00000011 ; 54d2 ; ......................##
                        dc.b %00000000, %00000000, %00000011 ; 54d5 ; ......................##
                        dc.b %00000000, %00000000, %00000111 ; 54d8 ; .....................###
                        dc.b %00000000, %00000100, %00011111 ; 54db ; .............#.....#####
                        dc.b %00011111, %11111111, %11111111 ; 54de ; ...#####################
                        dc.b %00000111, %11111111, %11110011 ; 54e1 ; .....###############..##
                        dc.b %00000000, %00000110, %00000001 ; 54e4 ; .............##........#
                        dc.b %00000000, %00000000, %00000000 ; 54e7 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 54ea ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 54ed ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 54f0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 54f3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 54f6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 54f9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 54fc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_14    dc.b %00000000, %00000000, %00000000 ; 5500 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5503 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5506 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5509 ; ........................
                        dc.b %10000000, %00000000, %00000000 ; 550c ; #.......................
                        dc.b %10000000, %00000000, %00000000 ; 550f ; #.......................
                        dc.b %11000000, %00000000, %00000000 ; 5512 ; ##......................
                        dc.b %11000000, %00000000, %00000000 ; 5515 ; ##......................
                        dc.b %11100000, %00000000, %00000000 ; 5518 ; ###.....................
                        dc.b %11111000, %00100000, %00000000 ; 551b ; #####.....#.............
                        dc.b %11111111, %11111111, %11111000 ; 551e ; #####################...
                        dc.b %11001111, %11111111, %11100000 ; 5521 ; ##..###############.....
                        dc.b %10000000, %01100000, %00000000 ; 5524 ; #........##.............
                        dc.b %00000000, %00000000, %00000000 ; 5527 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 552a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 552d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5530 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5533 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5536 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5539 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 553c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_15    dc.b %00000000, %00000000, %00000000 ; 5540 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5543 ; ........................
                        dc.b %00000000, %00000000, %00000001 ; 5546 ; .......................#
                        dc.b %00000000, %00000000, %00000001 ; 5549 ; .......................#
                        dc.b %00000000, %00000000, %00000011 ; 554c ; ......................##
                        dc.b %00000000, %00000000, %00000011 ; 554f ; ......................##
                        dc.b %00000000, %00000000, %00000011 ; 5552 ; ......................##
                        dc.b %00000000, %00000000, %00000111 ; 5555 ; .....................###
                        dc.b %00000000, %00001100, %00011111 ; 5558 ; ............##.....#####
                        dc.b %00011111, %11111111, %11111111 ; 555b ; ...#####################
                        dc.b %00001111, %11111111, %11111011 ; 555e ; ....#################.##
                        dc.b %00000011, %11111111, %11100011 ; 5561 ; ......#############...##
                        dc.b %00000000, %00000110, %00001001 ; 5564 ; .............##.....#..#
                        dc.b %00000000, %00000000, %00000001 ; 5567 ; .......................#
                        dc.b %00000000, %00000000, %00000000 ; 556a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 556d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5570 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5573 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5576 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5579 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 557c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_16    dc.b %00000000, %00000000, %00000000 ; 5580 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5583 ; ........................
                        dc.b %10000000, %00000000, %00000000 ; 5586 ; #.......................
                        dc.b %10000000, %00000000, %00000000 ; 5589 ; #.......................
                        dc.b %11000000, %00000000, %00000000 ; 558c ; ##......................
                        dc.b %11000000, %00000000, %00000000 ; 558f ; ##......................
                        dc.b %11000000, %00000000, %00000000 ; 5592 ; ##......................
                        dc.b %11100000, %00000000, %00000000 ; 5595 ; ###.....................
                        dc.b %11111000, %00110000, %00000000 ; 5598 ; #####.....##............
                        dc.b %11111111, %11111111, %11111000 ; 559b ; #####################...
                        dc.b %11011111, %11111111, %11110000 ; 559e ; ##.#################....
                        dc.b %11000111, %11111111, %11000000 ; 55a1 ; ##...#############......
                        dc.b %10010000, %01100000, %00000000 ; 55a4 ; #..#.....##.............
                        dc.b %10000000, %00000000, %00000000 ; 55a7 ; #.......................
                        dc.b %00000000, %00000000, %00000000 ; 55aa ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 55ad ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 55b0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 55b3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 55b6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 55b9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 55bc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_17    dc.b %00000000, %00000000, %00000000 ; 55c0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 55c3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 55c6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 55c9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 55cc ; ........................
                        dc.b %00000000, %00000000, %00000011 ; 55cf ; ......................##
                        dc.b %00000000, %00000000, %00000011 ; 55d2 ; ......................##
                        dc.b %00000000, %00000000, %00000011 ; 55d5 ; ......................##
                        dc.b %00000000, %00000000, %00000011 ; 55d8 ; ......................##
                        dc.b %00000000, %00000000, %00001111 ; 55db ; ....................####
                        dc.b %00000000, %00000000, %00111111 ; 55de ; ..................######
                        dc.b %00000000, %00000000, %11111100 ; 55e1 ; ................######..
                        dc.b %00000000, %00001111, %11110000 ; 55e4 ; ............########....
                        dc.b %00000000, %11111100, %00000000 ; 55e7 ; ........######..........
                        dc.b %00000111, %11000000, %00000000 ; 55ea ; .....#####..............
                        dc.b %00000000, %00000000, %00000000 ; 55ed ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 55f0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 55f3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 55f6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 55f9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 55fc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_18    dc.b %00000000, %00000000, %00000000 ; 5600 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5603 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5606 ; ........................
                        dc.b %00000000, %00000000, %00111000 ; 5609 ; ..................###...
                        dc.b %00000000, %00000000, %11100000 ; 560c ; ................###.....
                        dc.b %00000000, %00001111, %10000000 ; 560f ; ............#####.......
                        dc.b %10000000, %11111100, %00000000 ; 5612 ; #.......######..........
                        dc.b %11111111, %11000000, %00000000 ; 5615 ; ##########..............
                        dc.b %11111111, %00000000, %00000000 ; 5618 ; ########................
                        dc.b %11100000, %00000000, %00000000 ; 561b ; ###.....................
                        dc.b %11000000, %00000000, %00000000 ; 561e ; ##......................
                        dc.b %00000000, %00000000, %00000000 ; 5621 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5624 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5627 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 562a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 562d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5630 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5633 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5636 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5639 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 563c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_19    dc.b %00000000, %00000000, %00000000 ; 5640 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5643 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5646 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5649 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 564c ; ........................
                        dc.b %00000000, %00000000, %00011100 ; 564f ; ...................###..
                        dc.b %00000000, %00000000, %00011110 ; 5652 ; ...................####.
                        dc.b %00000000, %00000000, %00001111 ; 5655 ; ....................####
                        dc.b %00000000, %00000000, %00001111 ; 5658 ; ....................####
                        dc.b %00000000, %00000000, %00000111 ; 565b ; .....................###
                        dc.b %00000000, %00000000, %00011111 ; 565e ; ...................#####
                        dc.b %00000000, %00000000, %00111111 ; 5661 ; ..................######
                        dc.b %00000000, %00000110, %11111111 ; 5664 ; .............##.########
                        dc.b %00000000, %00000011, %11111110 ; 5667 ; ..............#########.
                        dc.b %00000000, %00001111, %11111000 ; 566a ; ............#########...
                        dc.b %00000000, %00111111, %11100000 ; 566d ; ..........#########.....
                        dc.b %00000000, %11111111, %00110000 ; 5670 ; ........########..##....
                        dc.b %00000011, %11111000, %00000000 ; 5673 ; ......#######...........
                        dc.b %00000111, %11000000, %00000000 ; 5676 ; .....#####..............
                        dc.b %00000000, %00000000, %00000000 ; 5679 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 567c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_1a    dc.b %00000000, %00000000, %00000000 ; 5680 ; ........................
                        dc.b %00000000, %00000000, %01100000 ; 5683 ; .................##.....
                        dc.b %00000000, %00000001, %11100000 ; 5686 ; ...............####.....
                        dc.b %00000000, %00001111, %11000000 ; 5689 ; ............######......
                        dc.b %00000011, %00111111, %10000000 ; 568c ; ......##..#######.......
                        dc.b %00000001, %11111111, %00000000 ; 568f ; .......#########........
                        dc.b %00000111, %11111100, %00000000 ; 5692 ; .....#########..........
                        dc.b %10111111, %11110000, %00000000 ; 5695 ; #.##########............
                        dc.b %11111111, %10110000, %00000000 ; 5698 ; #########.##............
                        dc.b %11111110, %00000000, %00000000 ; 569b ; #######.................
                        dc.b %11111000, %00000000, %00000000 ; 569e ; #####...................
                        dc.b %11110000, %00000000, %00000000 ; 56a1 ; ####....................
                        dc.b %11111000, %00000000, %00000000 ; 56a4 ; #####...................
                        dc.b %00111000, %00000000, %00000000 ; 56a7 ; ..###...................
                        dc.b %00000000, %00000000, %00000000 ; 56aa ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 56ad ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 56b0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 56b3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 56b6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 56b9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 56bc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_1b    dc.b %00000000, %00000000, %00000000 ; 56c0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 56c3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 56c6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 56c9 ; ........................
                        dc.b %00000000, %00000000, %00111000 ; 56cc ; ..................###...
                        dc.b %00000000, %00000000, %00111100 ; 56cf ; ..................####..
                        dc.b %00000000, %00000000, %00011110 ; 56d2 ; ...................####.
                        dc.b %00000000, %00000000, %00001111 ; 56d5 ; ....................####
                        dc.b %00000000, %00000000, %00000111 ; 56d8 ; .....................###
                        dc.b %00000000, %00000000, %00000111 ; 56db ; .....................###
                        dc.b %00000000, %00000000, %00000011 ; 56de ; ......................##
                        dc.b %00000000, %00000000, %00001111 ; 56e1 ; ....................####
                        dc.b %00000000, %00000001, %10011111 ; 56e4 ; ...............##..#####
                        dc.b %00000000, %00000000, %11111111 ; 56e7 ; ................########
                        dc.b %00000000, %00000001, %11111111 ; 56ea ; ...............#########
                        dc.b %00000000, %00000011, %11111110 ; 56ed ; ..............#########.
                        dc.b %00000000, %00000111, %11111100 ; 56f0 ; .............#########..
                        dc.b %00000000, %00011111, %11100110 ; 56f3 ; ...........########..##.
                        dc.b %00000000, %00111111, %10000000 ; 56f6 ; ..........#######.......
                        dc.b %00000000, %01111100, %00000000 ; 56f9 ; .........#####..........
                        dc.b %00000000, %00000000, %00000000 ; 56fc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_1c    dc.b %00000000, %00000001, %10000000 ; 5700 ; ...............##.......
                        dc.b %00000000, %00000111, %10000000 ; 5703 ; .............####.......
                        dc.b %00000000, %00001111, %10000000 ; 5706 ; ............#####.......
                        dc.b %00000011, %00111111, %00000000 ; 5709 ; ......##..######........
                        dc.b %00000001, %11111110, %00000000 ; 570c ; .......########.........
                        dc.b %00000001, %11111100, %00000000 ; 570f ; .......#######..........
                        dc.b %00000111, %11111000, %00000000 ; 5712 ; .....########...........
                        dc.b %10011111, %11110000, %00000000 ; 5715 ; #..#########............
                        dc.b %11111111, %11011000, %00000000 ; 5718 ; ##########.##...........
                        dc.b %11111111, %00000000, %00000000 ; 571b ; ########................
                        dc.b %11111100, %00000000, %00000000 ; 571e ; ######..................
                        dc.b %11111001, %10000000, %00000000 ; 5721 ; #####..##...............
                        dc.b %11111100, %00000000, %00000000 ; 5724 ; ######..................
                        dc.b %11011110, %00000000, %00000000 ; 5727 ; ##.####.................
                        dc.b %00001110, %00000000, %00000000 ; 572a ; ....###.................
                        dc.b %01100000, %00000000, %00000000 ; 572d ; .##.....................
                        dc.b %00000000, %00000000, %00000000 ; 5730 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5733 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5736 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5739 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 573c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_1d    dc.b %00000000, %00000000, %00000000 ; 5740 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5743 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5746 ; ........................
                        dc.b %00011100, %00000000, %00000000 ; 5749 ; ...###..................
                        dc.b %00000111, %00000000, %00000000 ; 574c ; .....###................
                        dc.b %00000001, %11110000, %00000000 ; 574f ; .......#####............
                        dc.b %00000000, %01111110, %00000011 ; 5752 ; .........######.......##
                        dc.b %00000000, %00000111, %11111111 ; 5755 ; .............###########
                        dc.b %00000000, %00000000, %11111111 ; 5758 ; ................########
                        dc.b %00000000, %00000000, %00000111 ; 575b ; .....................###
                        dc.b %00000000, %00000000, %00000011 ; 575e ; ......................##
                        dc.b %00000000, %00000000, %00000000 ; 5761 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5764 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5767 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 576a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 576d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5770 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5773 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5776 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5779 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 577c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_1e    dc.b %00000000, %00000000, %00000000 ; 5780 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5783 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5786 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5789 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 578c ; ........................
                        dc.b %11000000, %00000000, %00000000 ; 578f ; ##......................
                        dc.b %11000000, %00000000, %00000000 ; 5792 ; ##......................
                        dc.b %11000000, %00000000, %00000000 ; 5795 ; ##......................
                        dc.b %11000000, %00000000, %00000000 ; 5798 ; ##......................
                        dc.b %11110000, %00000000, %00000000 ; 579b ; ####....................
                        dc.b %11111100, %00000000, %00000000 ; 579e ; ######..................
                        dc.b %00111111, %00000000, %00000000 ; 57a1 ; ..######................
                        dc.b %00001111, %11110000, %00000000 ; 57a4 ; ....########............
                        dc.b %00000000, %00111111, %00000000 ; 57a7 ; ..........######........
                        dc.b %00000000, %00000011, %11110000 ; 57aa ; ..............######....
                        dc.b %00000000, %00000000, %00000000 ; 57ad ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 57b0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 57b3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 57b6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 57b9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 57bc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_1f    dc.b %00000000, %00000000, %00000000 ; 57c0 ; ........................
                        dc.b %00000110, %00000000, %00000000 ; 57c3 ; .....##.................
                        dc.b %00000111, %10000000, %00000000 ; 57c6 ; .....####...............
                        dc.b %00000011, %11110000, %00000000 ; 57c9 ; ......######............
                        dc.b %00000001, %11111100, %11000000 ; 57cc ; .......#######..##......
                        dc.b %00000000, %11111111, %10000000 ; 57cf ; ........#########.......
                        dc.b %00000000, %00111111, %11100000 ; 57d2 ; ..........#########.....
                        dc.b %00000000, %00001111, %11111101 ; 57d5 ; ............##########.#
                        dc.b %00000000, %00001101, %11111111 ; 57d8 ; ............##.#########
                        dc.b %00000000, %00000000, %01111111 ; 57db ; .................#######
                        dc.b %00000000, %00000000, %00011111 ; 57de ; ...................#####
                        dc.b %00000000, %00000000, %00001111 ; 57e1 ; ....................####
                        dc.b %00000000, %00000000, %00011111 ; 57e4 ; ...................#####
                        dc.b %00000000, %00000000, %00011100 ; 57e7 ; ...................###..
                        dc.b %00000000, %00000000, %00000000 ; 57ea ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 57ed ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 57f0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 57f3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 57f6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 57f9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 57fc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_20    dc.b %00000000, %00000000, %00000000 ; 5800 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5803 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5806 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5809 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 580c ; ........................
                        dc.b %00111000, %00000000, %00000000 ; 580f ; ..###...................
                        dc.b %01111000, %00000000, %00000000 ; 5812 ; .####...................
                        dc.b %11110000, %00000000, %00000000 ; 5815 ; ####....................
                        dc.b %11110000, %00000000, %00000000 ; 5818 ; ####....................
                        dc.b %11100000, %00000000, %00000000 ; 581b ; ###.....................
                        dc.b %11111000, %00000000, %00000000 ; 581e ; #####...................
                        dc.b %11111100, %00000000, %00000000 ; 5821 ; ######..................
                        dc.b %11111111, %01100000, %00000000 ; 5824 ; ########.##.............
                        dc.b %01111111, %11000000, %00000000 ; 5827 ; .#########..............
                        dc.b %00011111, %11110000, %00000000 ; 582a ; ...#########............
                        dc.b %00000111, %11111100, %00000000 ; 582d ; .....#########..........
                        dc.b %00001100, %11111111, %00000000 ; 5830 ; ....##..########........
                        dc.b %00000000, %00011111, %11000000 ; 5833 ; ...........#######......
                        dc.b %00000000, %00000011, %11100000 ; 5836 ; ..............#####.....
                        dc.b %00000000, %00000000, %00000000 ; 5839 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 583c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_21    dc.b %00000001, %10000000, %00000000 ; 5840 ; .......##...............
                        dc.b %00000001, %11100000, %00000000 ; 5843 ; .......####.............
                        dc.b %00000001, %11110000, %00000000 ; 5846 ; .......#####............
                        dc.b %00000000, %11111100, %11000000 ; 5849 ; ........######..##......
                        dc.b %00000000, %01111111, %10000000 ; 584c ; .........########.......
                        dc.b %00000000, %00111111, %10000000 ; 584f ; ..........#######.......
                        dc.b %00000000, %00011111, %11100000 ; 5852 ; ...........########.....
                        dc.b %00000000, %00001111, %11111001 ; 5855 ; ............#########..#
                        dc.b %00000000, %00011011, %11111111 ; 5858 ; ...........##.##########
                        dc.b %00000000, %00000000, %11111111 ; 585b ; ................########
                        dc.b %00000000, %00000000, %00111111 ; 585e ; ..................######
                        dc.b %00000000, %00000001, %10011111 ; 5861 ; ...............##..#####
                        dc.b %00000000, %00000000, %00111111 ; 5864 ; ..................######
                        dc.b %00000000, %00000000, %01111011 ; 5867 ; .................####.##
                        dc.b %00000000, %00000000, %01110000 ; 586a ; .................###....
                        dc.b %00000000, %00000000, %00000110 ; 586d ; .....................##.
                        dc.b %00000000, %00000000, %00000000 ; 5870 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5873 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5876 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5879 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 587c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_22    dc.b %00000000, %00000000, %00000000 ; 5880 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5883 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5886 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5889 ; ........................
                        dc.b %00011100, %00000000, %00000000 ; 588c ; ...###..................
                        dc.b %00111100, %00000000, %00000000 ; 588f ; ..####..................
                        dc.b %01111000, %00000000, %00000000 ; 5892 ; .####...................
                        dc.b %11110000, %00000000, %00000000 ; 5895 ; ####....................
                        dc.b %11100000, %00000000, %00000000 ; 5898 ; ###.....................
                        dc.b %11100000, %00000000, %00000000 ; 589b ; ###.....................
                        dc.b %11000000, %00000000, %00000000 ; 589e ; ##......................
                        dc.b %11110000, %00000000, %00000000 ; 58a1 ; ####....................
                        dc.b %11111001, %10000000, %00000000 ; 58a4 ; #####..##...............
                        dc.b %11111111, %00000000, %00000000 ; 58a7 ; ########................
                        dc.b %11111111, %10000000, %00000000 ; 58aa ; #########...............
                        dc.b %01111111, %11000000, %00000000 ; 58ad ; .#########..............
                        dc.b %00111111, %11100000, %00000000 ; 58b0 ; ..#########.............
                        dc.b %01100111, %11111000, %00000000 ; 58b3 ; .##..########...........
                        dc.b %00000001, %11111100, %00000000 ; 58b6 ; .......#######..........
                        dc.b %00000000, %00111110, %00000000 ; 58b9 ; ..........#####.........
                        dc.b %00000000, %00000000, %00000000 ; 58bc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_23    dc.b %00000000, %00000000, %00000000 ; 58c0 ; ........................
                        dc.b %00000000, %00011000, %00000000 ; 58c3 ; ...........##...........
                        dc.b %00000000, %00000000, %00000000 ; 58c6 ; ........................
                        dc.b %00000000, %00011000, %00000000 ; 58c9 ; ...........##...........
                        dc.b %00000000, %00000000, %00000000 ; 58cc ; ........................
                        dc.b %00000000, %00011000, %00000000 ; 58cf ; ...........##...........
                        dc.b %00000000, %00000000, %00000000 ; 58d2 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 58d5 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 58d8 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 58db ; ........................
                        dc.b %11001100, %00011000, %00110011 ; 58de ; ##..##.....##.....##..##
                        dc.b %00000000, %00000000, %00000000 ; 58e1 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 58e4 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 58e7 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 58ea ; ........................
                        dc.b %00000000, %00011000, %00000000 ; 58ed ; ...........##...........
                        dc.b %00000000, %00000000, %00000000 ; 58f0 ; ........................
                        dc.b %00000000, %00011000, %00000000 ; 58f3 ; ...........##...........
                        dc.b %00000000, %00000000, %00000000 ; 58f6 ; ........................
                        dc.b %00000000, %00011000, %00000000 ; 58f9 ; ...........##...........
                        dc.b %00000000, %00000000, %00000000 ; 58fc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_24    dc.b %00110000, %00000000, %00001100 ; 5900 ; ..##................##..
                        dc.b %01111000, %00000000, %00011110 ; 5903 ; .####..............####.
                        dc.b %11111100, %00000000, %00111111 ; 5906 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5909 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 590c ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 590f ; ######............######
                        dc.b %01111000, %00000000, %00011110 ; 5912 ; .####..............####.
                        dc.b %00000000, %00000000, %00000000 ; 5915 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5918 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 591b ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 591e ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5921 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5924 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5927 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 592a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 592d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5930 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5933 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5936 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5939 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 593c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_25    dc.b %00011000, %00000000, %00011000 ; 5940 ; ...##..............##...
                        dc.b %00111100, %00000000, %00111100 ; 5943 ; ..####............####..
                        dc.b %01111110, %00000000, %01111110 ; 5946 ; .######..........######.
                        dc.b %01111110, %00000000, %01111110 ; 5949 ; .######..........######.
                        dc.b %01111110, %00000000, %01111110 ; 594c ; .######..........######.
                        dc.b %01111110, %00000000, %01111110 ; 594f ; .######..........######.
                        dc.b %00111100, %00000000, %00111100 ; 5952 ; ..####............####..
                        dc.b %00000000, %00000000, %00000000 ; 5955 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5958 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 595b ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 595e ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5961 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5964 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5967 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 596a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 596d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5970 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5973 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5976 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5979 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 597c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_26    dc.b %00011100, %00000000, %00111000 ; 5980 ; ...###............###...
                        dc.b %00111110, %00000000, %01111100 ; 5983 ; ..#####..........#####..
                        dc.b %00111110, %00000000, %01111100 ; 5986 ; ..#####..........#####..
                        dc.b %00111110, %00000000, %01111100 ; 5989 ; ..#####..........#####..
                        dc.b %00111110, %00000000, %01111100 ; 598c ; ..#####..........#####..
                        dc.b %00011100, %00000000, %00111000 ; 598f ; ...###............###...
                        dc.b %00000000, %00000000, %00000000 ; 5992 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5995 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5998 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 599b ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 599e ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 59a1 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 59a4 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 59a7 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 59aa ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 59ad ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 59b0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 59b3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 59b6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 59b9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 59bc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_27    dc.b %00001110, %00000000, %01110000 ; 59c0 ; ....###..........###....
                        dc.b %00011111, %00000000, %11111000 ; 59c3 ; ...#####........#####...
                        dc.b %00011111, %00000000, %11111000 ; 59c6 ; ...#####........#####...
                        dc.b %00011111, %00000000, %11111000 ; 59c9 ; ...#####........#####...
                        dc.b %00001110, %00000000, %01110000 ; 59cc ; ....###..........###....
                        dc.b %00000000, %00000000, %00000000 ; 59cf ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 59d2 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 59d5 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 59d8 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 59db ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 59de ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 59e1 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 59e4 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 59e7 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 59ea ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 59ed ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 59f0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 59f3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 59f6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 59f9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 59fc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_28    dc.b %00000111, %00000000, %11100000 ; 5a00 ; .....###........###.....
                        dc.b %00001111, %10000001, %11110000 ; 5a03 ; ....#####......#####....
                        dc.b %00001111, %10000001, %11110000 ; 5a06 ; ....#####......#####....
                        dc.b %00000111, %00000000, %11100000 ; 5a09 ; .....###........###.....
                        dc.b %00000000, %00000000, %00000000 ; 5a0c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a0f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a12 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a15 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a18 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a1b ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a1e ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a21 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a24 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a27 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a2a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a2d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a30 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a33 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a36 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a39 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a3c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_29    dc.b %00000011, %00000000, %11000000 ; 5a40 ; ......##........##......
                        dc.b %00000111, %10000001, %11100000 ; 5a43 ; .....####......####.....
                        dc.b %00000111, %10000001, %11100000 ; 5a46 ; .....####......####.....
                        dc.b %00000011, %00000000, %11000000 ; 5a49 ; ......##........##......
                        dc.b %00000000, %00000000, %00000000 ; 5a4c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a4f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a52 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a55 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a58 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a5b ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a5e ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a61 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a64 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a67 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a6a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a6d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a70 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a73 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a76 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a79 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a7c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_2a    dc.b %00000011, %10000001, %11000000 ; 5a80 ; ......###......###......
                        dc.b %00000011, %10000001, %11000000 ; 5a83 ; ......###......###......
                        dc.b %00000011, %10000001, %11000000 ; 5a86 ; ......###......###......
                        dc.b %00000000, %00000000, %00000000 ; 5a89 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a8c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a8f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a92 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a95 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a98 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a9b ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5a9e ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5aa1 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5aa4 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5aa7 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5aaa ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5aad ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5ab0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5ab3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5ab6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5ab9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5abc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_2b    dc.b %00000001, %11000011, %10000000 ; 5ac0 ; .......###....###.......
                        dc.b %00000001, %11000011, %10000000 ; 5ac3 ; .......###....###.......
                        dc.b %00000000, %00000000, %00000000 ; 5ac6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5ac9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5acc ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5acf ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5ad2 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5ad5 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5ad8 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5adb ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5ade ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5ae1 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5ae4 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5ae7 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5aea ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5aed ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5af0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5af3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5af6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5af9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5afc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_2c    dc.b %00000000, %11000011, %00000000 ; 5b00 ; ........##....##........
                        dc.b %00000000, %11000011, %00000000 ; 5b03 ; ........##....##........
                        dc.b %00000000, %00000000, %00000000 ; 5b06 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b09 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b0c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b0f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b12 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b15 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b18 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b1b ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b1e ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b21 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b24 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b27 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b2a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b2d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b30 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b33 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b36 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b39 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b3c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_2d    dc.b %00000000, %01100110, %00000000 ; 5b40 ; .........##..##.........
                        dc.b %00000000, %00000000, %00000000 ; 5b43 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b46 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b49 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b4c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b4f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b52 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b55 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b58 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b5b ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b5e ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b61 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b64 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b67 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b6a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b6d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b70 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b73 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b76 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b79 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b7c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_2e    dc.b %00000000, %00111100, %00000000 ; 5b80 ; ..........####..........
                        dc.b %00000000, %00000000, %00000000 ; 5b83 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b86 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b89 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b8c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b8f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b92 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b95 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b98 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b9b ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5b9e ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5ba1 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5ba4 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5ba7 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5baa ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5bad ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5bb0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5bb3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5bb6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5bb9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5bbc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_2f    dc.b %00000000, %00011000, %00000000 ; 5bc0 ; ...........##...........
                        dc.b %00000000, %00000000, %00000000 ; 5bc3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5bc6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5bc9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5bcc ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5bcf ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5bd2 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5bd5 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5bd8 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5bdb ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5bde ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5be1 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5be4 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5be7 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5bea ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5bed ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5bf0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5bf3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5bf6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5bf9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5bfc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_30    dc.b %01111000, %00000000, %00011110 ; 5c00 ; .####..............####.
                        dc.b %11111100, %00000000, %00111111 ; 5c03 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5c06 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5c09 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5c0c ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5c0f ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5c12 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5c15 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5c18 ; ######............######
                        dc.b %10110100, %00000000, %00101101 ; 5c1b ; #.##.#............#.##.#
                        dc.b %01111000, %00000000, %00011110 ; 5c1e ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5c21 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5c24 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5c27 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5c2a ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5c2d ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5c30 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5c33 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5c36 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5c39 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5c3c ; .####..............####.
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_31    dc.b %00000000, %00000000, %00000000 ; 5c40 ; ........................
                        dc.b %01111000, %00000000, %00011110 ; 5c43 ; .####..............####.
                        dc.b %11111100, %00000000, %00111111 ; 5c46 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5c49 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5c4c ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5c4f ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5c52 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5c55 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5c58 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5c5b ; ######............######
                        dc.b %10110100, %00000000, %00101101 ; 5c5e ; #.##.#............#.##.#
                        dc.b %01111000, %00000000, %00011110 ; 5c61 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5c64 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5c67 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5c6a ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5c6d ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5c70 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5c73 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5c76 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5c79 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5c7c ; .####..............####.
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_32    dc.b %00000000, %00000000, %00000000 ; 5c80 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5c83 ; ........................
                        dc.b %01111000, %00000000, %00011110 ; 5c86 ; .####..............####.
                        dc.b %11111100, %00000000, %00111111 ; 5c89 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5c8c ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5c8f ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5c92 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5c95 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5c98 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5c9b ; ######............######
                        dc.b %10110100, %00000000, %00101101 ; 5c9e ; #.##.#............#.##.#
                        dc.b %01111000, %00000000, %00011110 ; 5ca1 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5ca4 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5ca7 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5caa ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5cad ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5cb0 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5cb3 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5cb6 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5cb9 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5cbc ; .####..............####.
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_33    dc.b %00000000, %00000000, %00000000 ; 5cc0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5cc3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5cc6 ; ........................
                        dc.b %01111000, %00000000, %00011110 ; 5cc9 ; .####..............####.
                        dc.b %11111100, %00000000, %00111111 ; 5ccc ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5ccf ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5cd2 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5cd5 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5cd8 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5cdb ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5cde ; ######............######
                        dc.b %10110100, %00000000, %00101101 ; 5ce1 ; #.##.#............#.##.#
                        dc.b %01111000, %00000000, %00011110 ; 5ce4 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5ce7 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5cea ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5ced ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5cf0 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5cf3 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5cf6 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5cf9 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5cfc ; .####..............####.
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_34    dc.b %00000000, %00000000, %00000000 ; 5d00 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5d03 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5d06 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5d09 ; ........................
                        dc.b %01111000, %00000000, %00011110 ; 5d0c ; .####..............####.
                        dc.b %11111100, %00000000, %00111111 ; 5d0f ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5d12 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5d15 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5d18 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5d1b ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5d1e ; ######............######
                        dc.b %10110100, %00000000, %00101101 ; 5d21 ; #.##.#............#.##.#
                        dc.b %01111000, %00000000, %00011110 ; 5d24 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5d27 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5d2a ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5d2d ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5d30 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5d33 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5d36 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5d39 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5d3c ; .####..............####.
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_35    dc.b %00000000, %00000000, %00000000 ; 5d40 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5d43 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5d46 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5d49 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5d4c ; ........................
                        dc.b %01111000, %00000000, %00011110 ; 5d4f ; .####..............####.
                        dc.b %11111100, %00000000, %00111111 ; 5d52 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5d55 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5d58 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5d5b ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5d5e ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5d61 ; ######............######
                        dc.b %10110100, %00000000, %00101101 ; 5d64 ; #.##.#............#.##.#
                        dc.b %01111000, %00000000, %00011110 ; 5d67 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5d6a ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5d6d ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5d70 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5d73 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5d76 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5d79 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5d7c ; .####..............####.
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_36    dc.b %00000000, %00000000, %00000000 ; 5d80 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5d83 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5d86 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5d89 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5d8c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5d8f ; ........................
                        dc.b %01111000, %00000000, %00011110 ; 5d92 ; .####..............####.
                        dc.b %11111100, %00000000, %00111111 ; 5d95 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5d98 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5d9b ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5d9e ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5da1 ; ######............######
                        dc.b %10110100, %00000000, %00101101 ; 5da4 ; #.##.#............#.##.#
                        dc.b %01111000, %00000000, %00011110 ; 5da7 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5daa ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5dad ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5db0 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5db3 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5db6 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5db9 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5dbc ; .####..............####.
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_37    dc.b %00000000, %00000000, %00000000 ; 5dc0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5dc3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5dc6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5dc9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5dcc ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5dcf ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5dd2 ; ........................
                        dc.b %01111000, %00000000, %00011110 ; 5dd5 ; .####..............####.
                        dc.b %11111100, %00000000, %00111111 ; 5dd8 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5ddb ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5dde ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5de1 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5de4 ; ######............######
                        dc.b %10110100, %00000000, %00101101 ; 5de7 ; #.##.#............#.##.#
                        dc.b %01111000, %00000000, %00011110 ; 5dea ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5ded ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5df0 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5df3 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5df6 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5df9 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5dfc ; .####..............####.
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_38    dc.b %00000000, %00000000, %00000000 ; 5e00 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5e03 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5e06 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5e09 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5e0c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5e0f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5e12 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5e15 ; ........................
                        dc.b %01111000, %00000000, %00011110 ; 5e18 ; .####..............####.
                        dc.b %11111100, %00000000, %00111111 ; 5e1b ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5e1e ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5e21 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5e24 ; ######............######
                        dc.b %10110100, %00000000, %00101101 ; 5e27 ; #.##.#............#.##.#
                        dc.b %01111000, %00000000, %00011110 ; 5e2a ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5e2d ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5e30 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5e33 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5e36 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5e39 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5e3c ; .####..............####.
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_39    dc.b %00000000, %00000000, %00000000 ; 5e40 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5e43 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5e46 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5e49 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5e4c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5e4f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5e52 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5e55 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5e58 ; ........................
                        dc.b %01111000, %00000000, %00011110 ; 5e5b ; .####..............####.
                        dc.b %11111100, %00000000, %00111111 ; 5e5e ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5e61 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5e64 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5e67 ; ######............######
                        dc.b %10110100, %00000000, %00101101 ; 5e6a ; #.##.#............#.##.#
                        dc.b %01111000, %00000000, %00011110 ; 5e6d ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5e70 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5e73 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5e76 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5e79 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5e7c ; .####..............####.
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_3a    dc.b %00000000, %00000000, %00000000 ; 5e80 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5e83 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5e86 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5e89 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5e8c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5e8f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5e92 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5e95 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5e98 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5e9b ; ........................
                        dc.b %01111000, %00000000, %00011110 ; 5e9e ; .####..............####.
                        dc.b %11111100, %00000000, %00111111 ; 5ea1 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5ea4 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5ea7 ; ######............######
                        dc.b %10110100, %00000000, %00101101 ; 5eaa ; #.##.#............#.##.#
                        dc.b %01111000, %00000000, %00011110 ; 5ead ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5eb0 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5eb3 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5eb6 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5eb9 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5ebc ; .####..............####.
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_3b    dc.b %00000000, %00000000, %00000000 ; 5ec0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5ec3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5ec6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5ec9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5ecc ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5ecf ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5ed2 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5ed5 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5ed8 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5edb ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5ede ; ........................
                        dc.b %01111000, %00000000, %00011110 ; 5ee1 ; .####..............####.
                        dc.b %11111100, %00000000, %00111111 ; 5ee4 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5ee7 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5eea ; ######............######
                        dc.b %10110100, %00000000, %00101101 ; 5eed ; #.##.#............#.##.#
                        dc.b %01111000, %00000000, %00011110 ; 5ef0 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5ef3 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5ef6 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5ef9 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5efc ; .####..............####.
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_3c    dc.b %00000000, %00000000, %00000000 ; 5f00 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f03 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f06 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f09 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f0c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f0f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f12 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f15 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f18 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f1b ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f1e ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f21 ; ........................
                        dc.b %01111000, %00000000, %00011110 ; 5f24 ; .####..............####.
                        dc.b %11111100, %00000000, %00111111 ; 5f27 ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5f2a ; ######............######
                        dc.b %10110100, %00000000, %00101101 ; 5f2d ; #.##.#............#.##.#
                        dc.b %01111000, %00000000, %00011110 ; 5f30 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5f33 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5f36 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5f39 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5f3c ; .####..............####.
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_3d    dc.b %00000000, %00000000, %00000000 ; 5f40 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f43 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f46 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f49 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f4c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f4f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f52 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f55 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f58 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f5b ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f5e ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f61 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f64 ; ........................
                        dc.b %01111000, %00000000, %00011110 ; 5f67 ; .####..............####.
                        dc.b %11111100, %00000000, %00111111 ; 5f6a ; ######............######
                        dc.b %11111100, %00000000, %00111111 ; 5f6d ; ######............######
                        dc.b %10110100, %00000000, %00101101 ; 5f70 ; #.##.#............#.##.#
                        dc.b %01111000, %00000000, %00011110 ; 5f73 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5f76 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5f79 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5f7c ; .####..............####.
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_3e    dc.b %00000000, %00000000, %00000000 ; 5f80 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f83 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f86 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f89 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f8c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f8f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f92 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f95 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f98 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f9b ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5f9e ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5fa1 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5fa4 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5fa7 ; ........................
                        dc.b %01111000, %00000000, %00011110 ; 5faa ; .####..............####.
                        dc.b %11111100, %00000000, %00111111 ; 5fad ; ######............######
                        dc.b %10110100, %00000000, %00101101 ; 5fb0 ; #.##.#............#.##.#
                        dc.b %01111000, %00000000, %00011110 ; 5fb3 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5fb6 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5fb9 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5fbc ; .####..............####.
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_3f    dc.b %00000000, %00000000, %00000000 ; 5fc0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5fc3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5fc6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5fc9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5fcc ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5fcf ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5fd2 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5fd5 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5fd8 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5fdb ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5fde ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5fe1 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5fe4 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5fe7 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5fea ; ........................
                        dc.b %01111000, %00000000, %00011110 ; 5fed ; .####..............####.
                        dc.b %11111100, %00000000, %00111111 ; 5ff0 ; ######............######
                        dc.b %10110100, %00000000, %00101101 ; 5ff3 ; #.##.#............#.##.#
                        dc.b %01111000, %00000000, %00011110 ; 5ff6 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5ff9 ; .####..............####.
                        dc.b %01111000, %00000000, %00011110 ; 5ffc ; .####..............####.
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_40    dc.b %00000000, %00000000, %00000000 ; 6000 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6003 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6006 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6009 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 600c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 600f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6012 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6015 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6018 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 601b ; ........................
                        dc.b %00000000, %00011000, %00000000 ; 601e ; ...........##...........
                        dc.b %00000000, %00000000, %00000000 ; 6021 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6024 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6027 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 602a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 602d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6030 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6033 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6036 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6039 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 603c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_41    dc.b %00000000, %00000000, %00000000 ; 6040 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6043 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6046 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6049 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 604c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 604f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6052 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6055 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6058 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 605b ; ........................
                        dc.b %00000000, %00011000, %00000000 ; 605e ; ...........##...........
                        dc.b %00000000, %00011000, %00000000 ; 6061 ; ...........##...........
                        dc.b %00000000, %00000000, %00000000 ; 6064 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6067 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 606a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 606d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6070 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6073 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6076 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6079 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 607c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_42    dc.b %00000000, %00000000, %00000000 ; 6080 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6083 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6086 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6089 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 608c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 608f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6092 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6095 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6098 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 609b ; ........................
                        dc.b %00000000, %00011000, %00000000 ; 609e ; ...........##...........
                        dc.b %00000000, %00111100, %00000000 ; 60a1 ; ..........####..........
                        dc.b %00000000, %00011000, %00000000 ; 60a4 ; ...........##...........
                        dc.b %00000000, %00000000, %00000000 ; 60a7 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 60aa ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 60ad ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 60b0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 60b3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 60b6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 60b9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 60bc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_43    dc.b %00000000, %00000000, %00000000 ; 60c0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 60c3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 60c6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 60c9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 60cc ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 60cf ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 60d2 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 60d5 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 60d8 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 60db ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 60de ; ........................
                        dc.b %00000000, %00011000, %00000000 ; 60e1 ; ...........##...........
                        dc.b %00000000, %00111100, %00000000 ; 60e4 ; ..........####..........
                        dc.b %00000000, %00111100, %00000000 ; 60e7 ; ..........####..........
                        dc.b %00000000, %00011000, %00000000 ; 60ea ; ...........##...........
                        dc.b %00000000, %00000000, %00000000 ; 60ed ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 60f0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 60f3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 60f6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 60f9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 60fc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_44    dc.b %00000000, %00000000, %00000000 ; 6100 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6103 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6106 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6109 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 610c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 610f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6112 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6115 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6118 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 611b ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 611e ; ........................
                        dc.b %00000000, %00011000, %00000000 ; 6121 ; ...........##...........
                        dc.b %00000000, %00111100, %00000000 ; 6124 ; ..........####..........
                        dc.b %00000000, %01111110, %00000000 ; 6127 ; .........######.........
                        dc.b %00000000, %00111100, %00000000 ; 612a ; ..........####..........
                        dc.b %00000000, %00011000, %00000000 ; 612d ; ...........##...........
                        dc.b %00000000, %00000000, %00000000 ; 6130 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6133 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6136 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6139 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 613c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_45    dc.b %00000000, %00000000, %00000000 ; 6140 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6143 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6146 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6149 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 614c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 614f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6152 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6155 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6158 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 615b ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 615e ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6161 ; ........................
                        dc.b %00000000, %00011000, %00000000 ; 6164 ; ...........##...........
                        dc.b %00000000, %00111100, %00000000 ; 6167 ; ..........####..........
                        dc.b %00000000, %01111110, %00000000 ; 616a ; .........######.........
                        dc.b %00000000, %01111110, %00000000 ; 616d ; .........######.........
                        dc.b %00000000, %00111100, %00000000 ; 6170 ; ..........####..........
                        dc.b %00000000, %00011000, %00000000 ; 6173 ; ...........##...........
                        dc.b %00000000, %00000000, %00000000 ; 6176 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6179 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 617c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_46    dc.b %00000000, %00000000, %00000000 ; 6180 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6183 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6186 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6189 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 618c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 618f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6192 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6195 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6198 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 619b ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 619e ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 61a1 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 61a4 ; ........................
                        dc.b %00000000, %00011000, %00000000 ; 61a7 ; ...........##...........
                        dc.b %00000000, %00111100, %00000000 ; 61aa ; ..........####..........
                        dc.b %00000000, %01111110, %00000000 ; 61ad ; .........######.........
                        dc.b %00000000, %01111110, %00000000 ; 61b0 ; .........######.........
                        dc.b %00000000, %01111110, %00000000 ; 61b3 ; .........######.........
                        dc.b %00000000, %00111100, %00000000 ; 61b6 ; ..........####..........
                        dc.b %00000000, %00011000, %00000000 ; 61b9 ; ...........##...........
                        dc.b %00000000, %00000000, %00000000 ; 61bc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_47    dc.b %00000000, %00000000, %00000000 ; 61c0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 61c3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 61c6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 61c9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 61cc ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 61cf ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 61d2 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 61d5 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 61d8 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 61db ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 61de ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 61e1 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 61e4 ; ........................
                        dc.b %00000000, %00011000, %00000000 ; 61e7 ; ...........##...........
                        dc.b %00000000, %00111100, %00000000 ; 61ea ; ..........####..........
                        dc.b %00000000, %01111110, %00000000 ; 61ed ; .........######.........
                        dc.b %00000000, %01111110, %00000000 ; 61f0 ; .........######.........
                        dc.b %00000000, %01111110, %00000000 ; 61f3 ; .........######.........
                        dc.b %00000000, %01111110, %00000000 ; 61f6 ; .........######.........
                        dc.b %00000000, %00111100, %00000000 ; 61f9 ; ..........####..........
                        dc.b %00000000, %00011000, %00000000 ; 61fc ; ...........##...........
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_48    dc.b %00000000, %00000000, %00000000 ; 6200 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6203 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6206 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6209 ; ........................
                        dc.b %00001000, %00001000, %00000000 ; 620c ; ....#.......#...........
                        dc.b %00000110, %00110110, %00000000 ; 620f ; .....##...##.##.........
                        dc.b %00000011, %01101011, %01000000 ; 6212 ; ......##.##.#.##.#......
                        dc.b %00001010, %11101101, %10110000 ; 6215 ; ....#.#.###.##.##.##....
                        dc.b %00011010, %10101010, %10011000 ; 6218 ; ...##.#.#.#.#.#.#..##...
                        dc.b %00001101, %10011010, %01100000 ; 621b ; ....##.##..##.#..##.....
                        dc.b %00111010, %11101011, %10000000 ; 621e ; ..###.#.###.#.###.......
                        dc.b %10101010, %10100110, %10010000 ; 6221 ; #.#.#.#.#.#..##.#..#....
                        dc.b %01110110, %01101110, %10110100 ; 6224 ; .###.##..##.###.#.##.#..
                        dc.b %00101011, %10101010, %01101000 ; 6227 ; ..#.#.###.#.#.#..##.#...
                        dc.b %00000110, %10010110, %10101110 ; 622a ; .....##.#..#.##.#.#.###.
                        dc.b %00000011, %10101110, %10011001 ; 622d ; ......###.#.###.#..##..#
                        dc.b %00001001, %10101001, %10111000 ; 6230 ; ....#..##.#.#..##.###...
                        dc.b %00000011, %01001010, %10100100 ; 6233 ; ......##.#..#.#.#.#..#..
                        dc.b %00000000, %00000001, %11100000 ; 6236 ; ...............####.....
                        dc.b %00000000, %00000000, %10010000 ; 6239 ; ................#..#....
                        dc.b %00000000, %00000000, %10000000 ; 623c ; ................#.......
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_49    dc.b %00000000, %10010000, %00000000 ; 6240 ; ........#..#............
                        dc.b %00000000, %00100010, %00000010 ; 6243 ; ..........#...#.......#.
                        dc.b %00000000, %11101001, %11000001 ; 6246 ; ........###.#..###.....#
                        dc.b %00000000, %00000000, %10010011 ; 6249 ; ................#..#..##
                        dc.b %00000000, %00101000, %01110110 ; 624c ; ..........#.#....###.##.
                        dc.b %00001000, %00110110, %10101110 ; 624f ; ....#.....##.##.#.#.###.
                        dc.b %00000110, %00001011, %10101001 ; 6252 ; .....##.....#.###.#.#..#
                        dc.b %00111010, %10000110, %10011010 ; 6255 ; ..###.#.#....##.#..##.#.
                        dc.b %00000001, %10101001, %10101110 ; 6258 ; .......##.#.#..##.#.###.
                        dc.b %00100010, %10111010, %01101001 ; 625b ; ..#...#.#.###.#..##.#..#
                        dc.b %10011010, %01100110, %10110110 ; 625e ; #..##.#..##..##.#.##.##.
                        dc.b %00100111, %10101010, %10101010 ; 6261 ; ..#..####.#.#.#.#.#.#.#.
                        dc.b %00001000, %00001011, %10011011 ; 6264 ; ....#.......#.###..##.##
                        dc.b %00000000, %10001001, %10101001 ; 6267 ; ........#...#..##.#.#..#
                        dc.b %00000000, %00100110, %10111010 ; 626a ; ..........#..##.#.###.#.
                        dc.b %00000000, %10101010, %01101010 ; 626d ; ........#.#.#.#..##.#.#.
                        dc.b %00000000, %10011110, %10100111 ; 6270 ; ........#..####.#.#..###
                        dc.b %00000000, %11000001, %00111010 ; 6273 ; ........##.....#..###.#.
                        dc.b %00000010, %01001000, %00011001 ; 6276 ; ......#..#..#......##..#
                        dc.b %00000011, %00000100, %00001000 ; 6279 ; ......##.....#......#...
                        dc.b %00000000, %00000000, %00000000 ; 627c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_4a    dc.b %00001100, %00000000, %00000000 ; 6280 ; ....##..................
                        dc.b %10011000, %00001000, %00000000 ; 6283 ; #..##.......#...........
                        dc.b %11100000, %00110110, %00000000 ; 6286 ; ###.......##.##.........
                        dc.b %01100000, %00010000, %00000000 ; 6289 ; .##........#............
                        dc.b %10110011, %10100000, %01110000 ; 628c ; #.##..###.#......###....
                        dc.b %10011010, %10100010, %10000000 ; 628f ; #..##.#.#.#...#.#.......
                        dc.b %11101110, %01100010, %11000000 ; 6292 ; ###.###..##...#.##......
                        dc.b %10101010, %10101101, %10000000 ; 6295 ; #.#.#.#.#.#.##.##.......
                        dc.b %10100110, %11101010, %10001010 ; 6298 ; #.#..##.###.#.#.#...#.#.
                        dc.b %01111010, %10011010, %11101100 ; 629b ; .####.#.#..##.#.###.##..
                        dc.b %10101001, %10101011, %01100100 ; 629e ; #.#.#..##.#.#.##.##..#..
                        dc.b %10011011, %10100110, %10101001 ; 62a1 ; #..##.###.#..##.#.#.#..#
                        dc.b %11101010, %01111010, %10011110 ; 62a4 ; ###.#.#..####.#.#..####.
                        dc.b %10101010, %10101000, %00101000 ; 62a7 ; #.#.#.#.#.#.#.....#.#...
                        dc.b %10000110, %10011000, %00000100 ; 62aa ; #....##.#..##........#..
                        dc.b %01001110, %10101110, %00000000 ; 62ad ; .#..###.#.#.###.........
                        dc.b %10000001, %00111010, %10000000 ; 62b0 ; #......#..###.#.#.......
                        dc.b %10010010, %10000110, %11000000 ; 62b3 ; #..#..#.#....##.##......
                        dc.b %10110011, %10000001, %10000000 ; 62b6 ; #.##..###......##.......
                        dc.b %11100010, %01100000, %10000000 ; 62b9 ; ###...#..##.....#.......
                        dc.b %00000001, %00000000, %00000000 ; 62bc ; .......#................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_4b    dc.b %00000000, %00000000, %00000000 ; 62c0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 62c3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 62c6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 62c9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 62cc ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 62cf ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 62d2 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 62d5 ; ........................
                        dc.b %00000000, %00000000, %00000110 ; 62d8 ; .....................##.
                        dc.b %00000000, %01111110, %00001110 ; 62db ; .........######.....###.
                        dc.b %00111111, %11111111, %11111111 ; 62de ; ..######################
                        dc.b %11111111, %11111111, %11110000 ; 62e1 ; ####################....
                        dc.b %00111111, %11111110, %00000000 ; 62e4 ; ..#############.........
                        dc.b %00000000, %00000000, %00000000 ; 62e7 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 62ea ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 62ed ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 62f0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 62f3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 62f6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 62f9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 62fc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_SeaPlane_4c    dc.b %00000000, %00000000, %00000000 ; 6300 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6303 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6306 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6309 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 630c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 630f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6312 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6315 ; ........................
                        dc.b %01100000, %00000000, %00000000 ; 6318 ; .##.....................
                        dc.b %01110000, %01111110, %00000000 ; 631b ; .###.....######.........
                        dc.b %11111111, %11111111, %11111100 ; 631e ; ######################..
                        dc.b %00001111, %11111111, %11111111 ; 6321 ; ....####################
                        dc.b %00000000, %01111111, %11111100 ; 6324 ; .........#############..
                        dc.b %00000000, %00000000, %00000000 ; 6327 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 632a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 632d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6330 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6333 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6336 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 6339 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 633c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SpriteBasePtr           set (BH_MemSprites - BH_MemVicGfx) / BH_SpriteDataLen
; -------------------------------------------------------------------------------------------------------------- ;
SP_Ptr_SeaPlane_00      =   SpriteBasePtr  + $00 ; $40 ; SeaPlane single sprite phase 1
SP_Ptr_SeaPlane_01      =   SpriteBasePtr  + $01 ; $41 ; SeaPlane single sprite phase 2
SP_Ptr_SeaPlane_02      =   SpriteBasePtr  + $02 ; $42 ; SeaPlane single sprite phase 3
SP_Ptr_SeaPlane_03      =   SpriteBasePtr  + $03 ; $43 ; SeaPlane single sprite phase 4
SP_Ptr_SeaPlane_04      =   SpriteBasePtr  + $04 ; $44 ; SeaPlane single sprite phase 5
SP_Ptr_SeaPlane_05      =   SpriteBasePtr  + $05 ; $45 ; SeaPlane single sprite phase 6
SP_Ptr_SeaPlane_06      =   SpriteBasePtr  + $06 ; $46 ; SeaPlane single sprite phase 7

SP_Ptr_SeaPlane_07      =   SpriteBasePtr  + $07 ; $47 ; SeaPlane double sprite phase 1 left
SP_Ptr_SeaPlane_08      =   SpriteBasePtr  + $08 ; $48 ; SeaPlane double sprite phase 1 right
SP_Ptr_SeaPlane_09      =   SpriteBasePtr  + $09 ; $49 ; SeaPlane double sprite phase 2 left
SP_Ptr_SeaPlane_0a      =   SpriteBasePtr  + $0a ; $4a ; SeaPlane double sprite phase 2 right
SP_Ptr_SeaPlane_0b      =   SpriteBasePtr  + $0b ; $4b ; SeaPlane double sprite phase 3 left
SP_Ptr_SeaPlane_0c      =   SpriteBasePtr  + $0c ; $4c ; SeaPlane double sprite phase 3 right
SP_Ptr_SeaPlane_0d      =   SpriteBasePtr  + $0d ; $4d ; SeaPlane double sprite phase 4 left
SP_Ptr_SeaPlane_0e      =   SpriteBasePtr  + $0e ; $4e ; SeaPlane double sprite phase 4 right
SP_Ptr_SeaPlane_0f      =   SpriteBasePtr  + $0f ; $4f ; SeaPlane double sprite phase 5 left
SP_Ptr_SeaPlane_10      =   SpriteBasePtr  + $10 ; $50 ; SeaPlane double sprite phase 5 right

SP_Ptr_SeaPlane_11      =   SpriteBasePtr  + $11 ; $51 ; SeaPlane turn away mid phase 1 left
SP_Ptr_SeaPlane_12      =   SpriteBasePtr  + $12 ; $52 ; SeaPlane turn away mid phase 1 right
SP_Ptr_SeaPlane_13      =   SpriteBasePtr  + $13 ; $53 ; SeaPlane turn away mid phase 2 left
SP_Ptr_SeaPlane_14      =   SpriteBasePtr  + $14 ; $54 ; SeaPlane turn away mid phase 3 right
SP_Ptr_SeaPlane_15      =   SpriteBasePtr  + $15 ; $55 ; SeaPlane turn away mid phase 3 left
SP_Ptr_SeaPlane_16      =   SpriteBasePtr  + $16 ; $56 ; SeaPlane turn away mid phase 3 right

SP_Ptr_SeaPlane_17      =   SpriteBasePtr  + $17 ; $57 ; SeaPlane turn away left phase 1 left
SP_Ptr_SeaPlane_18      =   SpriteBasePtr  + $18 ; $58 ; SeaPlane turn away left phase 1 right
SP_Ptr_SeaPlane_19      =   SpriteBasePtr  + $19 ; $59 ; SeaPlane turn away left phase 2 left
SP_Ptr_SeaPlane_1a      =   SpriteBasePtr  + $1a ; $5a ; SeaPlane turn away left phase 2 right
SP_Ptr_SeaPlane_1b      =   SpriteBasePtr  + $1b ; $5b ; SeaPlane turn away left phase 3 left
SP_Ptr_SeaPlane_1c      =   SpriteBasePtr  + $1c ; $5c ; SeaPlane turn away left phase 3 right

SP_Ptr_SeaPlane_1d      =   SpriteBasePtr  + $1d ; $5d ; SeaPlane turn away right phase 1 left
SP_Ptr_SeaPlane_1e      =   SpriteBasePtr  + $1e ; $5e ; SeaPlane turn away right phase 1 right
SP_Ptr_SeaPlane_1f      =   SpriteBasePtr  + $1f ; $5f ; SeaPlane turn away right phase 2 left
SP_Ptr_SeaPlane_20      =   SpriteBasePtr  + $20 ; $60 ; SeaPlane turn away right phase 2 right
SP_Ptr_SeaPlane_21      =   SpriteBasePtr  + $21 ; $61 ; SeaPlane turn away right phase 3 left
SP_Ptr_SeaPlane_22      =   SpriteBasePtr  + $22 ; $62 ; SeaPlane turn away right phase 3 right

SP_Ptr_SeaPlane_23      =   SpriteBasePtr  + $23 ; $63 ; target cross
SP_Ptr_SeaPlane_24      =   SpriteBasePtr  + $24 ; $64 ; bullet phase  1 - max
SP_Ptr_SeaPlane_25      =   SpriteBasePtr  + $25 ; $65 ; bullet phase  2
SP_Ptr_SeaPlane_26      =   SpriteBasePtr  + $26 ; $66 ; bullet phase  3
SP_Ptr_SeaPlane_27      =   SpriteBasePtr  + $27 ; $67 ; bullet phase  4
SP_Ptr_SeaPlane_28      =   SpriteBasePtr  + $28 ; $68 ; bullet phase  5
SP_Ptr_SeaPlane_29      =   SpriteBasePtr  + $29 ; $69 ; bullet phase  6
SP_Ptr_SeaPlane_2a      =   SpriteBasePtr  + $2a ; $6a ; bullet phase  7
SP_Ptr_SeaPlane_2b      =   SpriteBasePtr  + $2b ; $6b ; bullet phase  8
SP_Ptr_SeaPlane_2c      =   SpriteBasePtr  + $2c ; $6c ; bullet phase  9
SP_Ptr_SeaPlane_2d      =   SpriteBasePtr  + $2d ; $6d ; bullet phase 10
SP_Ptr_SeaPlane_2e      =   SpriteBasePtr  + $2e ; $6e ; bullet phase 11
SP_Ptr_SeaPlane_2f      =   SpriteBasePtr  + $2f ; $6f ; bullet phase 12 - min
SP_Ptr_SeaPlane_30      =   SpriteBasePtr  + $30 ; $70 ; cannon move up max
SP_Ptr_SeaPlane_31      =   SpriteBasePtr  + $31 ; $71 ; cannon move down phase  1
SP_Ptr_SeaPlane_32      =   SpriteBasePtr  + $32 ; $72 ; cannon move down phase  2
SP_Ptr_SeaPlane_33      =   SpriteBasePtr  + $33 ; $73 ; cannon move down phase  3
SP_Ptr_SeaPlane_34      =   SpriteBasePtr  + $34 ; $74 ; cannon move down phase  4
SP_Ptr_SeaPlane_35      =   SpriteBasePtr  + $35 ; $75 ; cannon move down phase  5
SP_Ptr_SeaPlane_36      =   SpriteBasePtr  + $36 ; $76 ; cannon move down phase  6
SP_Ptr_SeaPlane_37      =   SpriteBasePtr  + $37 ; $77 ; cannon move down phase  7
SP_Ptr_SeaPlane_38      =   SpriteBasePtr  + $38 ; $78 ; cannon move down phase  8
SP_Ptr_SeaPlane_39      =   SpriteBasePtr  + $39 ; $79 ; cannon move down phase  9
SP_Ptr_SeaPlane_3a      =   SpriteBasePtr  + $3a ; $7a ; cannon move down phase 10
SP_Ptr_SeaPlane_3b      =   SpriteBasePtr  + $3b ; $7b ; cannon move down phase 11
SP_Ptr_SeaPlane_3c      =   SpriteBasePtr  + $3c ; $7c ; cannon move down phase 12
SP_Ptr_SeaPlane_3d      =   SpriteBasePtr  + $3d ; $7d ; cannon move down phase 13
SP_Ptr_SeaPlane_3e      =   SpriteBasePtr  + $3e ; $7e ; cannon move down phase 14
SP_Ptr_SeaPlane_3f      =   SpriteBasePtr  + $3f ; $7f ; cannon move down phase 15
SP_Ptr_SeaPlane_40      =   SpriteBasePtr  + $40 ; $80 ; cannon move down max
SP_Ptr_SeaPlane_41      =   SpriteBasePtr  + $41 ; $81 ; enemy shot min
SP_Ptr_SeaPlane_42      =   SpriteBasePtr  + $42 ; $82 ; enemy shot phase 1
SP_Ptr_SeaPlane_43      =   SpriteBasePtr  + $43 ; $83 ; enemy shot phase 2
SP_Ptr_SeaPlane_44      =   SpriteBasePtr  + $44 ; $84 ; enemy shot phase 3
SP_Ptr_SeaPlane_45      =   SpriteBasePtr  + $45 ; $85 ; enemy shot phase 4
SP_Ptr_SeaPlane_46      =   SpriteBasePtr  + $46 ; $86 ; enemy shot phase 5
SP_Ptr_SeaPlane_47      =   SpriteBasePtr  + $47 ; $87 ; enemy shot max
SP_Ptr_SeaPlane_48      =   SpriteBasePtr  + $48 ; $88 ; explode transporter
SP_Ptr_SeaPlane_49      =   SpriteBasePtr  + $49 ; $89 ; explode SeaPlane left
SP_Ptr_SeaPlane_4a      =   SpriteBasePtr  + $4a ; $8a ; explode SeaPlane right
SP_Ptr_SeaPlane_4b      =   SpriteBasePtr  + $4b ; $8b ; transporter fly left
SP_Ptr_SeaPlane_4c      =   SpriteBasePtr  + $4c ; $8c ; transporter fly right
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_00             set BH_SpriteStore + $00 * BH_SpriteDataLen ; $5000 - $40
SP_Store_01             set BH_SpriteStore + $01 * BH_SpriteDataLen ; $5040 - $41
SP_Store_02             set BH_SpriteStore + $02 * BH_SpriteDataLen ; $5080 - $42
SP_Store_03             set BH_SpriteStore + $03 * BH_SpriteDataLen ; $50c0 - $43
SP_Store_04             set BH_SpriteStore + $04 * BH_SpriteDataLen ; $5100 - $44
SP_Store_05             set BH_SpriteStore + $05 * BH_SpriteDataLen ; $5140 - $45
SP_Store_06             set BH_SpriteStore + $06 * BH_SpriteDataLen ; $5180 - $46
SP_Store_07             set BH_SpriteStore + $07 * BH_SpriteDataLen ; $51c0 - $47
                        
SP_Store_08             set BH_SpriteStore + $08 * BH_SpriteDataLen ; $5200 - $48
SP_Store_09             set BH_SpriteStore + $09 * BH_SpriteDataLen ; $5240 - $49
SP_Store_0a             set BH_SpriteStore + $0a * BH_SpriteDataLen ; $5280 - $4a
SP_Store_0b             set BH_SpriteStore + $0b * BH_SpriteDataLen ; $52c0 - $4b
SP_Store_0c             set BH_SpriteStore + $0c * BH_SpriteDataLen ; $5300 - $4c
SP_Store_0d             set BH_SpriteStore + $0d * BH_SpriteDataLen ; $5340 - $4d
SP_Store_0e             set BH_SpriteStore + $0e * BH_SpriteDataLen ; $5380 - $4e
SP_Store_0f             set BH_SpriteStore + $0f * BH_SpriteDataLen ; $53c0 - $4f
                        
SP_Store_10             set BH_SpriteStore + $10 * BH_SpriteDataLen ; $5400 - $50
SP_Store_11             set BH_SpriteStore + $11 * BH_SpriteDataLen ; $5440 - $51
SP_Store_12             set BH_SpriteStore + $12 * BH_SpriteDataLen ; $5480 - $52
SP_Store_13             set BH_SpriteStore + $13 * BH_SpriteDataLen ; $54c0 - $53
SP_Store_14             set BH_SpriteStore + $14 * BH_SpriteDataLen ; $5500 - $54
SP_Store_15             set BH_SpriteStore + $15 * BH_SpriteDataLen ; $5540 - $55
SP_Store_16             set BH_SpriteStore + $16 * BH_SpriteDataLen ; $5580 - $56
SP_Store_17             set BH_SpriteStore + $17 * BH_SpriteDataLen ; $55c0 - $57
                        
SP_Store_18             set BH_SpriteStore + $18 * BH_SpriteDataLen ; $5600 - $58
SP_Store_19             set BH_SpriteStore + $19 * BH_SpriteDataLen ; $5640 - $59
SP_Store_1a             set BH_SpriteStore + $1a * BH_SpriteDataLen ; $5680 - $5a
SP_Store_1b             set BH_SpriteStore + $1b * BH_SpriteDataLen ; $56c0 - $5b
SP_Store_1c             set BH_SpriteStore + $1c * BH_SpriteDataLen ; $5700 - $5c
SP_Store_1d             set BH_SpriteStore + $1d * BH_SpriteDataLen ; $5740 - $5d
SP_Store_1e             set BH_SpriteStore + $1e * BH_SpriteDataLen ; $5780 - $5e
SP_Store_1f             set BH_SpriteStore + $1f * BH_SpriteDataLen ; $57c0 - $5f
                        
SP_Store_20             set BH_SpriteStore + $20 * BH_SpriteDataLen ; $5800 - $60
SP_Store_21             set BH_SpriteStore + $21 * BH_SpriteDataLen ; $5840 - $61
SP_Store_22             set BH_SpriteStore + $22 * BH_SpriteDataLen ; $5880 - $62
SP_Store_23             set BH_SpriteStore + $23 * BH_SpriteDataLen ; $58c0 - $63
SP_Store_24             set BH_SpriteStore + $24 * BH_SpriteDataLen ; $5900 - $64
SP_Store_25             set BH_SpriteStore + $25 * BH_SpriteDataLen ; $5940 - $65
SP_Store_26             set BH_SpriteStore + $26 * BH_SpriteDataLen ; $5980 - $66
SP_Store_27             set BH_SpriteStore + $27 * BH_SpriteDataLen ; $59c0 - $67
                        
SP_Store_28             set BH_SpriteStore + $28 * BH_SpriteDataLen ; $5a00 - $68
SP_Store_29             set BH_SpriteStore + $29 * BH_SpriteDataLen ; $5a40 - $69
SP_Store_2a             set BH_SpriteStore + $2a * BH_SpriteDataLen ; $5a80 - $6a
SP_Store_2b             set BH_SpriteStore + $2b * BH_SpriteDataLen ; $5ac0 - $6b
SP_Store_2c             set BH_SpriteStore + $2c * BH_SpriteDataLen ; $5b00 - $6c
SP_Store_2d             set BH_SpriteStore + $2d * BH_SpriteDataLen ; $5b40 - $6d
SP_Store_2e             set BH_SpriteStore + $2e * BH_SpriteDataLen ; $5b80 - $6e
SP_Store_2f             set BH_SpriteStore + $2f * BH_SpriteDataLen ; $5bc0 - $6f
                        
SP_Store_30             set BH_SpriteStore + $30 * BH_SpriteDataLen ; $5c00 - $60
SP_Store_31             set BH_SpriteStore + $31 * BH_SpriteDataLen ; $5c40 - $61
SP_Store_32             set BH_SpriteStore + $32 * BH_SpriteDataLen ; $5c80 - $62
SP_Store_33             set BH_SpriteStore + $33 * BH_SpriteDataLen ; $5cc0 - $63
SP_Store_34             set BH_SpriteStore + $34 * BH_SpriteDataLen ; $5d00 - $64
SP_Store_35             set BH_SpriteStore + $35 * BH_SpriteDataLen ; $5d40 - $65
SP_Store_36             set BH_SpriteStore + $36 * BH_SpriteDataLen ; $5d80 - $66
SP_Store_37             set BH_SpriteStore + $37 * BH_SpriteDataLen ; $5dc0 - $67
                        
SP_Store_38             set BH_SpriteStore + $38 * BH_SpriteDataLen ; $5e00 - $68
SP_Store_39             set BH_SpriteStore + $39 * BH_SpriteDataLen ; $5e40 - $69
SP_Store_3a             set BH_SpriteStore + $3a * BH_SpriteDataLen ; $5e80 - $6a
SP_Store_3b             set BH_SpriteStore + $3b * BH_SpriteDataLen ; $5ec0 - $6b
SP_Store_3c             set BH_SpriteStore + $3c * BH_SpriteDataLen ; $5f00 - $6c
SP_Store_3d             set BH_SpriteStore + $3d * BH_SpriteDataLen ; $5f40 - $6d
SP_Store_3e             set BH_SpriteStore + $3e * BH_SpriteDataLen ; $5f80 - $6e
SP_Store_3f             set BH_SpriteStore + $3f * BH_SpriteDataLen ; $5fc0 - $6f
                        
SP_Store_40             set BH_SpriteStore + $40 * BH_SpriteDataLen ; $6000 - $70
SP_Store_41             set BH_SpriteStore + $41 * BH_SpriteDataLen ; $6040 - $71
SP_Store_42             set BH_SpriteStore + $42 * BH_SpriteDataLen ; $6080 - $72
SP_Store_43             set BH_SpriteStore + $43 * BH_SpriteDataLen ; $60c0 - $73
SP_Store_44             set BH_SpriteStore + $44 * BH_SpriteDataLen ; $6100 - $74
SP_Store_45             set BH_SpriteStore + $45 * BH_SpriteDataLen ; $6140 - $75
SP_Store_46             set BH_SpriteStore + $46 * BH_SpriteDataLen ; $6180 - $76
SP_Store_47             set BH_SpriteStore + $47 * BH_SpriteDataLen ; $61c0 - $77
                        
SP_Store_48             set BH_SpriteStore + $48 * BH_SpriteDataLen ; $6200 - $78
SP_Store_49             set BH_SpriteStore + $49 * BH_SpriteDataLen ; $6240 - $79
SP_Store_4a             set BH_SpriteStore + $4a * BH_SpriteDataLen ; $6280 - $7a
SP_Store_4b             set BH_SpriteStore + $4b * BH_SpriteDataLen ; $62c0 - $7b
SP_Store_4c             set BH_SpriteStore + $4c * BH_SpriteDataLen ; $6300 - $7c
; -------------------------------------------------------------------------------------------------------------- ;
